/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block.entity;

import com.tcn.cosmoslibrary.common.blockentity.CosmosBlockEntityUpdateable;
import com.tcn.cosmoslibrary.common.capability.IEnergyCapBE;
import com.tcn.cosmoslibrary.common.capability.IFluidCapBE;
import com.tcn.cosmoslibrary.common.capability.IItemCapBE;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.enums.EnumConnectionType;
import com.tcn.cosmoslibrary.common.enums.EnumSideState;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUILock;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.IFluidStorage;
import com.tcn.cosmoslibrary.common.interfaces.block.IBlockInteract;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEConnectionType;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBESided;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUILockable;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUpdates;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleConnector;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallConnector;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleArmourWorkbench;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleCharger;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleCrafter;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleFurnace;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;

public class BlockEntityModuleConnector
extends CosmosBlockEntityUpdateable
implements IBlockInteract,
MenuProvider,
Nameable,
WorldlyContainer,
IBESided,
IFluidHandler,
IFluidStorage,
IBEUpdates.FluidBE,
IBEConnectionType,
IBEUIMode,
IBEUILockable,
IEnergyCapBE,
IFluidCapBE,
IItemCapBE {
    private EnumSideState[] SIDE_STATE_ARRAY = EnumSideState.getStandardArray();
    private EnumConnectionType TYPE = EnumConnectionType.getStandardValue();
    private NonNullList<ItemStack> inventoryItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private Pocket pocket;
    private int update = 0;
    private EnumUIMode uiMode = EnumUIMode.DARK;
    private EnumUIHelp uiHelp = EnumUIHelp.HIDDEN;
    private EnumUILock uiLock = EnumUILock.PRIVATE;
    private final int BUCKET_IN_SLOT = 54;
    private final int BUCKET_OUT_SLOT = 55;

    public BlockEntityModuleConnector(BlockPos posIn, BlockState stateIn) {
        super((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_CONNECTOR.get(), posIn, stateIn);
    }

    public BlockEntityModuleConnector(BlockPos posIn) {
        this(posIn, null);
    }

    public Pocket getPocket() {
        if (this.level.isClientSide) {
            return this.pocket;
        }
        return StorageManager.getPocketFromChunkPosition(this.getLevel(), CosmosChunkPos.scaleToChunkPos((BlockPos)this.getBlockPos()));
    }

    public void sendUpdates(boolean forceUpdate) {
        if (this.getLevel() != null) {
            this.setChanged();
            BlockState state = this.getBlockState();
            BlockWallConnector block = (BlockWallConnector)state.getBlock();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
            if (forceUpdate) {
                if (!this.getLevel().isClientSide()) {
                    this.getLevel().setBlockAndUpdate(this.getBlockPos(), block.updateState(state, this.getBlockPos(), this.level));
                    if (this.getPocket() != null) {
                        this.getPocket().updateBaseConnectors(this.getLevel());
                    }
                }
            } else if (!this.getLevel().isClientSide()) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), block.updateState(state, this.getBlockPos(), this.level));
            }
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("side", this.getSide(Direction.UP).getIndex());
        compound.putInt("type", this.getConnectionType().getIndex());
        if (this.getPocket().exists()) {
            this.getPocket().writeToNBT(compound, provider);
        }
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        int side = compound.getInt("side");
        int type = compound.getInt("type");
        this.setSide(Direction.UP, EnumSideState.getStateFromIndex((int)side), false);
        this.setConnectionType(EnumConnectionType.getStateFromIndex((int)type), false);
        if (PocketUtil.hasPocketKey(compound)) {
            this.pocket = Pocket.readFromNBT(compound, provider);
        }
        this.inventoryItems = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
        this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
        this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.sendUpdates(true);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        CompoundTag tag_ = pkt.getTag();
        this.handleUpdateTag(tag_, provider);
    }

    public void onLoad() {
    }

    public static void tick(Level levelIn, BlockPos posIn, BlockState stateIn, BlockEntityModuleConnector entityIn) {
        if (entityIn.getPocket() != null) {
            entityIn.checkFluidSlots();
        }
        if (!levelIn.isClientSide()) {
            entityIn.pushEnergy(Direction.DOWN);
            entityIn.pushEnergy(Direction.UP);
            entityIn.pushEnergy(Direction.NORTH);
            entityIn.pushEnergy(Direction.SOUTH);
            entityIn.pushEnergy(Direction.EAST);
            entityIn.pushEnergy(Direction.WEST);
            entityIn.pullEnergy(Direction.DOWN);
            entityIn.pullEnergy(Direction.UP);
            entityIn.pullEnergy(Direction.NORTH);
            entityIn.pullEnergy(Direction.SOUTH);
            entityIn.pullEnergy(Direction.EAST);
            entityIn.pullEnergy(Direction.WEST);
            entityIn.pushFluid(Direction.DOWN);
            entityIn.pushFluid(Direction.UP);
            entityIn.pushFluid(Direction.NORTH);
            entityIn.pushFluid(Direction.SOUTH);
            entityIn.pushFluid(Direction.EAST);
            entityIn.pushFluid(Direction.WEST);
            entityIn.pullFluid(Direction.DOWN);
            entityIn.pullFluid(Direction.UP);
            entityIn.pullFluid(Direction.NORTH);
            entityIn.pullFluid(Direction.SOUTH);
            entityIn.pullFluid(Direction.EAST);
            entityIn.pullFluid(Direction.WEST);
            entityIn.pushItems(Direction.DOWN);
            entityIn.pushItems(Direction.UP);
            entityIn.pushItems(Direction.NORTH);
            entityIn.pushItems(Direction.SOUTH);
            entityIn.pushItems(Direction.EAST);
            entityIn.pushItems(Direction.WEST);
            entityIn.pullItems(Direction.DOWN);
            entityIn.pullItems(Direction.UP);
            entityIn.pullItems(Direction.NORTH);
            entityIn.pullItems(Direction.SOUTH);
            entityIn.pullItems(Direction.EAST);
            entityIn.pullItems(Direction.WEST);
        }
        if (entityIn.update > 0) {
            --entityIn.update;
        } else {
            entityIn.update = 40;
            entityIn.sendUpdates(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushEnergy(Direction directionIn) {
        int extract;
        int actualExtract;
        IEnergyStorage storage;
        Object object;
        BlockPos otherPos = this.getBlockPos().offset(directionIn.getNormal());
        BlockEntity entity = this.getLevel().getBlockEntity(otherPos);
        if (!this.getConnectionType().equals((Object)EnumConnectionType.ENERGY)) return;
        if (entity == null || entity.isRemoved()) return;
        if (!this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_OUTPUT) || (object = this.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, otherPos, (Object)directionIn.getOpposite())) == null || !(object instanceof IEnergyStorage) || !(storage = (IEnergyStorage)object).canReceive() || !this.canExtract(directionIn) || (actualExtract = storage.receiveEnergy(extract = this.getPocket().extractEnergy(this.getPocket().getMaxExtract(), true), true)) <= 0) return;
        this.getPocket().extractEnergy(storage.receiveEnergy(actualExtract, false), false);
        this.sendUpdates(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pullEnergy(Direction directionIn) {
        IEnergyStorage storage;
        Object object;
        BlockPos otherPos = this.getBlockPos().offset(directionIn.getNormal());
        BlockEntity entity = this.getLevel().getBlockEntity(otherPos);
        if (!this.getConnectionType().equals((Object)EnumConnectionType.ENERGY)) return;
        if (entity == null || entity.isRemoved()) return;
        if (!this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_INPUT) || !this.getPocket().hasEnergyStored() || !this.canExtract(directionIn) || (object = this.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, otherPos, (Object)directionIn.getOpposite())) == null || !(object instanceof IEnergyStorage) || !(storage = (IEnergyStorage)object).canExtract() || !this.canReceive(directionIn)) return;
        int extract = storage.extractEnergy(this.getPocket().getMaxReceive(), true);
        int actualExtract = this.getPocket().receiveEnergy(extract, true);
        if (actualExtract <= 0) return;
        this.getPocket().receiveEnergy(storage.extractEnergy(actualExtract, false), false);
        this.sendUpdates(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushFluid(Direction directionIn) {
        IFluidHandler storage;
        BlockPos otherPos = this.getBlockPos().offset(directionIn.getNormal());
        BlockEntity entity = this.getLevel().getBlockEntity(otherPos);
        if (!this.getConnectionType().equals((Object)EnumConnectionType.FLUID)) return;
        if (entity == null || entity.isRemoved()) return;
        if (!this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_OUTPUT)) return;
        Object object = this.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, otherPos, (Object)directionIn);
        if (object == null || !(object instanceof IFluidHandler) || !(storage = (IFluidHandler)object).isFluidValid(0, this.getFluidInTank(0))) return;
        FluidStack stack = this.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        int lost = storage.fill(stack, IFluidHandler.FluidAction.SIMULATE);
        if (stack.isEmpty() || lost <= 0) return;
        storage.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        this.drain(lost, IFluidHandler.FluidAction.EXECUTE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pullFluid(Direction directionIn) {
        Object object;
        BlockPos otherPos = this.getBlockPos().offset(directionIn.getNormal());
        BlockEntity entity = this.getLevel().getBlockEntity(otherPos);
        if (!this.getConnectionType().equals((Object)EnumConnectionType.FLUID)) return;
        if (entity == null || entity.isRemoved()) return;
        if (!this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_INPUT) || (object = this.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, otherPos, (Object)directionIn)) == null || !(object instanceof IFluidHandler)) return;
        IFluidHandler storage = (IFluidHandler)object;
        FluidStack stack = storage.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        int lost = this.fill(stack, IFluidHandler.FluidAction.SIMULATE);
        if (stack.isEmpty() || lost <= 0) return;
        this.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        storage.drain(lost, IFluidHandler.FluidAction.EXECUTE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushItems(Direction directionIn) {
        Object object;
        BlockPos otherPos = this.getBlockPos().offset(directionIn.getNormal());
        BlockEntity entity = this.getLevel().getBlockEntity(otherPos);
        if (!this.getConnectionType().equals((Object)EnumConnectionType.ITEM)) return;
        if (entity == null || entity.isRemoved()) return;
        if (entity instanceof BlockEntityModuleConnector || entity instanceof BlockEntityModuleFurnace || entity instanceof BlockEntityModuleArmourWorkbench || entity instanceof BlockEntityModuleCrafter || entity instanceof BlockEntityModuleCharger || !this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_OUTPUT) || !((object = this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, otherPos, (Object)directionIn)) instanceof IItemHandler)) return;
        IItemHandler storage = (IItemHandler)object;
        block0: for (int i = 40; i < 48; ++i) {
            if (this.getPocket().getItem(i).isEmpty()) continue;
            for (int j = 0; j < storage.getSlots(); ++j) {
                ItemStack stack;
                if (!storage.isItemValid(j, this.getPocket().getItem(i)) || (!ItemStack.isSameItem((ItemStack)(stack = storage.getStackInSlot(j)), (ItemStack)this.getPocket().getItem(i)) || stack.getCount() >= 64) && !stack.isEmpty()) continue;
                storage.insertItem(j, this.getPocket().removeItem(i, 1), false);
                this.sendUpdates(true);
                continue block0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pullItems(Direction directionIn) {
        Object object;
        BlockPos otherPos = this.getBlockPos().offset(directionIn.getNormal());
        BlockEntity entity = this.getLevel().getBlockEntity(otherPos);
        if (!this.getConnectionType().equals((Object)EnumConnectionType.ITEM)) return;
        if (entity == null || entity.isRemoved()) return;
        if (entity instanceof BlockEntityModuleConnector || entity instanceof BlockEntityModuleFurnace || entity instanceof BlockEntityModuleArmourWorkbench || entity instanceof BlockEntityModuleCrafter || entity instanceof BlockEntityModuleCharger || !this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_INPUT) || !((object = this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, otherPos, (Object)directionIn)) instanceof IItemHandler)) return;
        IItemHandler storage = (IItemHandler)object;
        for (int i = 40; i < 48; ++i) {
            for (int j = 0; j < storage.getSlots(); ++j) {
                ItemStack homeStack = this.getPocket().getItem(i);
                if ((!ItemStack.isSameItem((ItemStack)homeStack, (ItemStack)storage.getStackInSlot(j)) || homeStack.getCount() >= 64) && !homeStack.isEmpty() || storage.extractItem(j, 1, true).isEmpty()) continue;
                this.getPocket().insertItem(i, storage.extractItem(j, 1, false), false);
                this.sendUpdates(true);
                return;
            }
        }
    }

    public void attack(BlockState state, Level worldIn, BlockPos pos, Player playerIn) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        if (PocketUtil.isDimensionEqual(worldIn, PocketsDimensionManager.POCKET_WORLD)) {
            Pocket pocketIn = this.getPocket();
            if (pocketIn == null) {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
                return ItemInteractionResult.FAIL;
            }
            if (playerIn.isShiftKeyDown()) {
                if (CosmosUtil.holdingWrench((Player)playerIn)) {
                    if (pocketIn.checkIfOwner(playerIn)) {
                        if (worldIn.isClientSide) return ItemInteractionResult.SUCCESS;
                        worldIn.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState());
                        worldIn.removeBlockEntity(pos);
                        CosmosUtil.addItem((Level)worldIn, (Player)playerIn, (Item)((Item)PocketsRegistrationManager.MODULE_CONNECTOR.get()), (int)1);
                        pocketIn.removeUpdateable(pos);
                        return ItemInteractionResult.SUCCESS;
                    }
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                    return ItemInteractionResult.FAIL;
                }
                if (CosmosUtil.handEmpty((Player)playerIn)) {
                    pocketIn.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                if (CosmosUtil.holdingWrench((Player)playerIn)) {
                    if (!worldIn.isClientSide) {
                        this.cycleSide(Direction.UP, true);
                    }
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)"dimensionalpocketsii.pocket.status.cycle_side").append((Component)this.getSide(Direction.UP).getColouredComp()));
                    return ItemInteractionResult.SUCCESS;
                }
                if (CosmosUtil.getStackItem((Player)playerIn) instanceof DyeItem || CosmosUtil.getStackItem((Player)playerIn).equals(PocketsRegistrationManager.DIMENSIONAL_SHARD.get())) {
                    if (!pocketIn.checkIfOwner(playerIn)) {
                        CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                        return ItemInteractionResult.FAIL;
                    }
                    ItemStack stack = CosmosUtil.getStack((Player)playerIn);
                    DyeColor dyeColour = DyeColor.getColor((ItemStack)stack);
                    ComponentColour colour = dyeColour != null ? ComponentColour.fromIndex((int)dyeColour.getId()) : ComponentColour.POCKET_PURPLE;
                    if (pocketIn.getDisplayColour() == colour.dec()) return ItemInteractionResult.FAIL;
                    pocketIn.setDisplayColour(playerIn, worldIn, colour.dec());
                    this.sendUpdates(true);
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)"dimensionalpocketsii.pocket.status.colour_update").append((Component)colour.getColouredName()));
                    return ItemInteractionResult.SUCCESS;
                }
                if (worldIn.isClientSide) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (!(playerIn instanceof ServerPlayer)) return ItemInteractionResult.SUCCESS;
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                if (pocketIn.checkIfOwner(playerIn)) {
                    serverPlayer.openMenu((MenuProvider)this, packetBuffer -> packetBuffer.writeBlockPos(this.getBlockPos()));
                    return ItemInteractionResult.SUCCESS;
                }
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                return ItemInteractionResult.FAIL;
            }
        }
        worldIn.sendBlockUpdated(pos, state, state, 3);
        return ItemInteractionResult.FAIL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level levelIn, BlockPos posIn, Player playerIn, BlockHitResult hit) {
        return InteractionResult.FAIL;
    }

    public EnumConnectionType getConnectionType() {
        return this.TYPE;
    }

    public void setConnectionType(EnumConnectionType type, boolean update) {
        this.TYPE = type;
        this.sendUpdates(update);
    }

    public void cycleConnectionType(boolean update) {
        EnumConnectionType next_state;
        this.TYPE = next_state = this.TYPE.getNextState();
        this.sendUpdates(update);
    }

    public EnumSideState getSide(Direction facing) {
        return this.SIDE_STATE_ARRAY[facing.get3DDataValue()];
    }

    public void setSide(Direction facing, EnumSideState side_state, boolean update) {
        for (int i = 0; i < this.SIDE_STATE_ARRAY.length; ++i) {
            this.SIDE_STATE_ARRAY[i] = side_state;
        }
        this.sendUpdates(update);
    }

    public EnumSideState[] getSideArray() {
        return this.SIDE_STATE_ARRAY;
    }

    public void setSideArray(EnumSideState[] new_array, boolean update) {
        this.SIDE_STATE_ARRAY = new_array;
        this.sendUpdates(update);
    }

    public void cycleSide(Direction facing, boolean update) {
        EnumSideState state = this.SIDE_STATE_ARRAY[facing.get3DDataValue()];
        EnumSideState state2 = state.getNextState();
        for (int i = 0; i < this.SIDE_STATE_ARRAY.length; ++i) {
            this.SIDE_STATE_ARRAY[i] = state2;
        }
        this.sendUpdates(update);
    }

    public boolean canConnect(Direction facing) {
        EnumSideState state = this.SIDE_STATE_ARRAY[facing.get3DDataValue()];
        return !state.equals((Object)EnumSideState.DISABLED);
    }

    public boolean getLockState() {
        return this.getPocket().getLockStateValue();
    }

    public void setLockState(boolean change, boolean update) {
        this.getPocket().setLockState(change);
        this.sendUpdates(update);
    }

    public int getFluidLevelScaled(int one) {
        return this.getPocket().getFluidLevelScaled(one);
    }

    public Fluid getCurrentStoredFluid() {
        this.setChanged();
        return this.getPocket().getCurrentStoredFluid();
    }

    public boolean isFluidEmpty() {
        return this.getPocket().isFluidTankEmpty();
    }

    public int getCurrentFluidAmount() {
        this.setChanged();
        return this.getPocket().getCurrentFluidAmount();
    }

    public String getCurrentStoredFluidName() {
        return this.getPocket().getCurrentStoredFluidName();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        this.setChanged();
        return this.getPocket().fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        this.setChanged();
        return this.getPocket().drain(resource.getAmount(), doDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        this.setChanged();
        return this.getPocket().drain(maxDrain, doDrain);
    }

    public boolean canFill(Direction from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(Direction from, Fluid fluid) {
        return true;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getPocket().getFluidTank().getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.getPocket().getFluidTankCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public FluidTank getTank() {
        return this.getPocket().getFluidTank();
    }

    public int getFluidCapacity() {
        return this.getPocket().getFluidTankCapacity();
    }

    public void checkFluidSlots() {
        if (!this.getLevel().isClientSide() && !this.getItem(54).isEmpty()) {
            ItemStack fillStack;
            Optional fluidStack = FluidUtil.getFluidContained((ItemStack)this.getItem(54));
            if (fluidStack.isPresent()) {
                int amount;
                FluidStack fluid = (FluidStack)fluidStack.get();
                if (fluid != null && this.isFluidValid(0, fluid) && fluid.getAmount() > 0 && (amount = this.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) == fluid.getAmount()) {
                    if (this.getItem(55).getItem().equals(FluidUtil.tryEmptyContainer((ItemStack)this.getItem((int)54), (IFluidHandler)this.getTank(), (int)amount, null, (boolean)false).result.getItem()) && this.getItem(55).getCount() < this.getItem(55).getMaxStackSize()) {
                        this.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        this.getItem(54).shrink(1);
                        this.getItem(55).grow(1);
                    }
                    if (this.getItem(55).isEmpty()) {
                        this.setItem(55, FluidUtil.tryEmptyContainer((ItemStack)this.getItem((int)54), (IFluidHandler)this.getTank(), (int)amount, null, (boolean)true).result);
                        this.getItem(54).shrink(1);
                    }
                }
            } else if (this.getCurrentFluidAmount() > 0 && this.getItem(55).isEmpty() && !(fillStack = FluidUtil.tryFillContainer((ItemStack)this.getItem((int)54), (IFluidHandler)this.getTank(), (int)this.getCurrentFluidAmount(), null, (boolean)true).result).isEmpty()) {
                this.setItem(55, fillStack);
                this.getItem(54).shrink(1);
                this.getPocket().updateFluidFillLevel();
            }
            this.sendUpdates(true);
        }
    }

    public AbstractContainerMenu createMenu(int indexIn, Inventory playerInventoryIn, Player playerIn) {
        return ContainerModuleConnector.createContainerServerSide(indexIn, playerInventoryIn, this.getPocket(), (Container)this, this.getBlockPos());
    }

    public Component getDisplayName() {
        return ComponentHelper.title((String)"dimensionalpocketsii.gui.connector.header");
    }

    public Component getName() {
        return ComponentHelper.title((String)"dimensionalpocketsii.gui.connector.header");
    }

    public boolean isEmpty() {
        if (this.level != null) {
            return this.getPocket().isEmpty();
        }
        return false;
    }

    public int getContainerSize() {
        if (this.level != null) {
            return this.getPocket().getContainerSize();
        }
        return 54;
    }

    public ItemStack getItem(int index) {
        if (index < 54) {
            return this.getPocket().getItem(index);
        }
        return (ItemStack)this.inventoryItems.get(index - 54);
    }

    public ItemStack removeItem(int index, int count) {
        this.setChanged();
        if (index < 54) {
            return this.getPocket().removeItem(index, count);
        }
        return ContainerHelper.removeItem(this.inventoryItems, (int)(index - 54), (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        this.setChanged();
        if (index < 54) {
            return this.getPocket().removeItemNoUpdate(index);
        }
        return ContainerHelper.takeItem(this.inventoryItems, (int)(index - 54));
    }

    public void setItem(int index, ItemStack stack) {
        if (index < 54) {
            this.getPocket().setItem(index, stack);
        } else {
            this.inventoryItems.set(index - 54, (Object)stack);
        }
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        if (this.level != null) {
            return this.getPocket().stillValid(player);
        }
        return true;
    }

    public void clearContent() {
        if (this.level != null) {
            this.getPocket().clearContent();
        }
    }

    public boolean canPlaceItemThroughFace(int indexIn, ItemStack itemStackIn, Direction directionIn) {
        return indexIn > 39 && indexIn < 48 && this.getConnectionType().equals((Object)EnumConnectionType.ITEM) && (this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_INPUT) || this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_NORMAL));
    }

    public boolean canTakeItemThroughFace(int indexIn, ItemStack itemStackIn, Direction directionIn) {
        return indexIn > 39 && indexIn < 48 && this.getConnectionType().equals((Object)EnumConnectionType.ITEM) && this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_OUTPUT);
    }

    public int[] getSlotsForFace(Direction arg0) {
        return new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    }

    public boolean canExtract(Direction directionIn) {
        EnumConnectionType type = this.getConnectionType();
        if (type.equals((Object)EnumConnectionType.ENERGY)) {
            EnumSideState state = this.getSide(directionIn.getOpposite());
            if (state.equals((Object)EnumSideState.INTERFACE_OUTPUT) || state.equals((Object)EnumSideState.INTERFACE_NORMAL)) {
                return this.getPocket().canExtractEnergy();
            }
            return false;
        }
        return false;
    }

    public boolean canReceive(Direction directionIn) {
        EnumConnectionType type = this.getConnectionType();
        if (type.equals((Object)EnumConnectionType.ENERGY)) {
            EnumSideState state = this.getSide(directionIn.getOpposite());
            if (state.equals((Object)EnumSideState.INTERFACE_INPUT) || this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_NORMAL)) {
                return this.getPocket().canReceiveEnergy();
            }
            return false;
        }
        return false;
    }

    public IFluidHandler getFluidCapability(final @Nullable Direction directionIn) {
        return new IFluidHandler(){

            public int getTanks() {
                if (BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.FLUID)) {
                    return BlockEntityModuleConnector.this.getPocket().getTanks();
                }
                return 0;
            }

            public FluidStack getFluidInTank(int tank) {
                if (BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.FLUID)) {
                    return BlockEntityModuleConnector.this.getPocket().getFluidInTank();
                }
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                if (BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.FLUID)) {
                    return BlockEntityModuleConnector.this.getPocket().getFluidTankCapacity();
                }
                return 0;
            }

            public boolean isFluidValid(int tank, FluidStack stack) {
                return BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.FLUID) && !BlockEntityModuleConnector.this.getSide(directionIn.getOpposite()).equals((Object)EnumSideState.DISABLED);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.FLUID) && !BlockEntityModuleConnector.this.getSide(directionIn.getOpposite()).equals((Object)EnumSideState.DISABLED)) {
                    return BlockEntityModuleConnector.this.getPocket().fill(resource, action);
                }
                return 0;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.FLUID) && !BlockEntityModuleConnector.this.getSide(directionIn.getOpposite()).equals((Object)EnumSideState.DISABLED)) {
                    BlockEntityModuleConnector.this.sendUpdates(true);
                    return BlockEntityModuleConnector.this.getPocket().drain(resource, action);
                }
                return FluidStack.EMPTY;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.FLUID) && !BlockEntityModuleConnector.this.getSide(directionIn.getOpposite()).equals((Object)EnumSideState.DISABLED)) {
                    BlockEntityModuleConnector.this.sendUpdates(true);
                    return BlockEntityModuleConnector.this.getPocket().drain(maxDrain, action);
                }
                return FluidStack.EMPTY;
            }
        };
    }

    public IEnergyStorage getEnergyCapability(final @Nullable Direction directionIn) {
        return new IEnergyStorage(){

            public int extractEnergy(int maxExtract, boolean simulate) {
                BlockEntityModuleConnector.this.sendUpdates(true);
                return BlockEntityModuleConnector.this.getPocket().extractEnergy(maxExtract, simulate);
            }

            public int getEnergyStored() {
                return BlockEntityModuleConnector.this.getPocket().getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return BlockEntityModuleConnector.this.getPocket().getMaxEnergyStored();
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                BlockEntityModuleConnector.this.sendUpdates(true);
                return BlockEntityModuleConnector.this.getPocket().receiveEnergy(maxReceive, simulate);
            }

            public boolean canReceive() {
                return BlockEntityModuleConnector.this.canReceive(directionIn);
            }

            public boolean canExtract() {
                return BlockEntityModuleConnector.this.canExtract(directionIn);
            }
        };
    }

    public IItemHandler getItemCapability(final Direction directionIn) {
        return new IItemHandler(){

            public int getSlots() {
                return 8;
            }

            public ItemStack getStackInSlot(int slot) {
                return BlockEntityModuleConnector.this.getPocket().getItem(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.ITEM) && slot > 40 && slot < 48) {
                    BlockEntityModuleConnector.this.sendUpdates(true);
                    return BlockEntityModuleConnector.this.getPocket().insertItem(slot, stack, simulate);
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.ITEM) && slot > 40 && slot < 48) {
                    BlockEntityModuleConnector.this.sendUpdates(true);
                    return BlockEntityModuleConnector.this.getPocket().extractItem(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return !BlockEntityModuleConnector.this.getSide(directionIn).equals((Object)EnumSideState.DISABLED) && !BlockEntityModuleConnector.this.getSide(directionIn).equals((Object)EnumSideState.INTERFACE_OUTPUT) && BlockEntityModuleConnector.this.getConnectionType().equals((Object)EnumConnectionType.ITEM);
            }
        };
    }

    public EnumUIMode getUIMode() {
        return this.uiMode;
    }

    public void setUIMode(EnumUIMode modeIn) {
        this.uiMode = modeIn;
    }

    public void cycleUIMode() {
        this.uiMode = EnumUIMode.getNextStateFromState((EnumUIMode)this.uiMode);
    }

    public EnumUIHelp getUIHelp() {
        return this.uiHelp;
    }

    public void setUIHelp(EnumUIHelp modeIn) {
        this.uiHelp = modeIn;
    }

    public void cycleUIHelp() {
        this.uiHelp = EnumUIHelp.getNextStateFromState((EnumUIHelp)this.uiHelp);
    }

    public EnumUILock getUILock() {
        return this.uiLock;
    }

    public void setUILock(EnumUILock modeIn) {
        this.uiLock = modeIn;
    }

    public void cycleUILock() {
        this.uiLock = EnumUILock.getNextStateFromState((EnumUILock)this.uiLock);
    }

    public void setOwner(Player playerIn) {
    }

    public boolean canPlayerAccess(Player playerIn) {
        if (this.getUILock().equals((Object)EnumUILock.PUBLIC)) {
            return true;
        }
        return this.getPocket().checkIfOwner(playerIn);
    }

    public boolean checkIfOwner(Player playerIn) {
        return this.getPocket().checkIfOwner(playerIn);
    }

    public int getFluidFillLevel() {
        return this.getPocket().getFluidFillLevel();
    }
}

