/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block.entity;

import com.google.common.collect.Lists;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUILock;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.block.IBlockInteract;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUILockable;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallFurnace;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockEntityModuleFurnace
extends BlockEntity
implements IBlockInteract,
WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible,
IBEUIMode,
IBEUILockable {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 2, 1};
    public NonNullList<ItemStack> inventoryItems = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private EnumUIMode uiMode = EnumUIMode.DARK;
    private EnumUIHelp uiHelp = EnumUIHelp.HIDDEN;
    private EnumUILock uiLock = EnumUILock.PRIVATE;
    public final ContainerData dataAccess = new ContainerData(){

        public int get(int p_221476_1_) {
            switch (p_221476_1_) {
                case 0: {
                    return BlockEntityModuleFurnace.this.litTime;
                }
                case 1: {
                    return BlockEntityModuleFurnace.this.litDuration;
                }
                case 2: {
                    return BlockEntityModuleFurnace.this.cookingProgress;
                }
                case 3: {
                    return BlockEntityModuleFurnace.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void set(int p_221477_1_, int p_221477_2_) {
            switch (p_221477_1_) {
                case 0: {
                    BlockEntityModuleFurnace.this.litTime = p_221477_2_;
                    break;
                }
                case 1: {
                    BlockEntityModuleFurnace.this.litDuration = p_221477_2_;
                    break;
                }
                case 2: {
                    BlockEntityModuleFurnace.this.cookingProgress = p_221477_2_;
                    break;
                }
                case 3: {
                    BlockEntityModuleFurnace.this.cookingTotalTime = p_221477_2_;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.SMELTING;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck = RecipeManager.createCheck(this.recipeType);
    private Pocket pocket;

    public BlockEntityModuleFurnace(BlockPos posIn, BlockState stateIn) {
        super((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_FURNACE.get(), posIn, stateIn);
    }

    public Pocket getPocket() {
        if (this.level.isClientSide) {
            return this.pocket;
        }
        return StorageManager.getPocketFromChunkPosition(this.getLevel(), CosmosChunkPos.scaleToChunkPos((BlockPos)this.getBlockPos()));
    }

    public void sendUpdates(boolean update) {
        this.setChanged();
        if (update && !this.level.isClientSide) {
            this.level.setBlockAndUpdate(this.getBlockPos(), this.getBlockState());
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.getPocket().exists()) {
            this.getPocket().writeToNBT(compound, provider);
        }
        compound.putInt("BurnTime", this.litTime);
        compound.putInt("CookTime", this.cookingProgress);
        compound.putInt("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        CompoundTag compoundnbt = new CompoundTag();
        this.recipesUsed.forEach((location, inte) -> compoundnbt.putInt(location.toString(), inte.intValue()));
        compound.put("RecipesUsed", (Tag)compoundnbt);
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
    }

    public void saveToItemStack(ItemStack stackIn, HolderLookup.Provider provider) {
        CompoundTag compound = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        compound.putInt("BurnTime", this.litTime);
        compound.putInt("CookTime", this.cookingProgress);
        compound.putInt("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        CompoundTag compoundnbt = new CompoundTag();
        this.recipesUsed.forEach((location, inte) -> compoundnbt.putInt(location.toString(), inte.intValue()));
        compound.put("RecipesUsed", (Tag)compoundnbt);
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
        stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (PocketUtil.hasPocketKey(compound)) {
            this.pocket = Pocket.readFromNBT(compound, provider);
        }
        this.inventoryItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        this.litTime = compound.getInt("BurnTime");
        this.cookingProgress = compound.getInt("CookTime");
        this.cookingTotalTime = compound.getInt("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.inventoryItems.get(1));
        CompoundTag compoundnbt = compound.getCompound("RecipesUsed");
        for (String s : compoundnbt.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compoundnbt.getInt(s));
        }
        this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
        this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
        this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
    }

    public void loadFromItemStack(ItemStack stackIn, HolderLookup.Provider provider) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag();
            this.inventoryItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
            this.litTime = compound.getInt("BurnTime");
            this.cookingProgress = compound.getInt("CookTime");
            this.cookingTotalTime = compound.getInt("CookTimeTotal");
            this.litDuration = this.getBurnDuration((ItemStack)this.inventoryItems.get(1));
            CompoundTag compoundnbt = compound.getCompound("RecipesUsed");
            for (String s : compoundnbt.getAllKeys()) {
                this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compoundnbt.getInt(s));
            }
            this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
            this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
            this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.sendUpdates(true);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        CompoundTag tag_ = pkt.getTag();
        this.handleUpdateTag(tag_, provider);
    }

    public void onLoad() {
    }

    public void attack(BlockState state, Level worldIn, BlockPos pos, Player player) {
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level levelIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        CosmosChunkPos chunkPos;
        Pocket pocketIn;
        levelIn.sendBlockUpdated(pos, state, state, 3);
        this.setChanged();
        this.sendUpdates(true);
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        if (!playerIn.isShiftKeyDown()) {
            if (levelIn.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                if (this.canPlayerAccess(playerIn)) {
                    serverPlayer.openMenu(state.getMenuProvider(levelIn, pos), packetBuffer -> packetBuffer.writeBlockPos(pos));
                    return ItemInteractionResult.SUCCESS;
                }
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                return ItemInteractionResult.FAIL;
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (!levelIn.isClientSide && (pocketIn = StorageManager.getPocketFromChunkPosition(levelIn, chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos))).exists()) {
            if (CosmosUtil.holdingWrench((Player)playerIn)) {
                if (pocketIn.checkIfOwner(playerIn)) {
                    ItemStack stack = new ItemStack(PocketsRegistrationManager.MODULE_FURNACE.getDelegate());
                    this.saveToItemStack(stack, (HolderLookup.Provider)levelIn.registryAccess());
                    levelIn.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState());
                    levelIn.removeBlockEntity(pos);
                    CosmosUtil.addStack((Level)levelIn, (Player)playerIn, (ItemStack)stack);
                    return ItemInteractionResult.SUCCESS;
                }
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                return ItemInteractionResult.FAIL;
            }
            if (CosmosUtil.handEmpty((Player)playerIn)) {
                pocketIn.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public InteractionResult useWithoutItem(BlockState state, Level levelIn, BlockPos posIn, Player playerIn, BlockHitResult hit) {
        return InteractionResult.FAIL;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public static void tick(Level levelIn, BlockPos posIn, BlockState stateIn, BlockEntityModuleFurnace blockEntityIn) {
        boolean flag3;
        boolean flag = blockEntityIn.isLit();
        boolean flag1 = false;
        if (blockEntityIn.isLit()) {
            --blockEntityIn.litTime;
        }
        ItemStack itemstack = (ItemStack)blockEntityIn.inventoryItems.get(1);
        ItemStack itemstack1 = (ItemStack)blockEntityIn.inventoryItems.get(0);
        boolean flag2 = !itemstack1.isEmpty();
        boolean bl = flag3 = !itemstack.isEmpty();
        if (blockEntityIn.isLit() || flag3 && flag2) {
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)blockEntityIn.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(itemstack1), levelIn).orElse(null) : null;
            int i = blockEntityIn.getMaxStackSize();
            if (!blockEntityIn.isLit() && BlockEntityModuleFurnace.canBurn(levelIn.registryAccess(), recipeholder, blockEntityIn.inventoryItems, i, blockEntityIn)) {
                blockEntityIn.litDuration = blockEntityIn.litTime = blockEntityIn.getBurnDuration(itemstack);
                if (blockEntityIn.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        blockEntityIn.inventoryItems.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (flag3) {
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            blockEntityIn.inventoryItems.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (blockEntityIn.isLit() && BlockEntityModuleFurnace.canBurn(levelIn.registryAccess(), recipeholder, blockEntityIn.inventoryItems, i, blockEntityIn)) {
                ++blockEntityIn.cookingProgress;
                if (blockEntityIn.cookingProgress == blockEntityIn.cookingTotalTime) {
                    blockEntityIn.cookingProgress = 0;
                    blockEntityIn.cookingTotalTime = BlockEntityModuleFurnace.getTotalCookTime(levelIn, blockEntityIn);
                    if (BlockEntityModuleFurnace.burn(levelIn.registryAccess(), recipeholder, blockEntityIn.inventoryItems, i, blockEntityIn)) {
                        blockEntityIn.setRecipeUsed(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                blockEntityIn.cookingProgress = 0;
            }
        } else if (!blockEntityIn.isLit() && blockEntityIn.cookingProgress > 0) {
            blockEntityIn.cookingProgress = Mth.clamp((int)(blockEntityIn.cookingProgress - 2), (int)0, (int)blockEntityIn.cookingTotalTime);
        }
        if (flag != blockEntityIn.isLit()) {
            flag1 = true;
            stateIn = (BlockState)stateIn.setValue((Property)BlockWallFurnace.LIT, (Comparable)Boolean.valueOf(blockEntityIn.isLit()));
            levelIn.setBlock(posIn, stateIn, 3);
        }
        if (flag1) {
            BlockEntityModuleFurnace.setChanged((Level)levelIn, (BlockPos)posIn, (BlockState)stateIn);
        }
    }

    private static boolean canBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, BlockEntityModuleFurnace furnace) {
        if (!((ItemStack)inventory.get(0)).isEmpty() && recipe != null) {
            ItemStack itemstack = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(furnace.getItem(0)), (HolderLookup.Provider)registryAccess);
            if (itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)inventory.get(2);
            if (itemstack1.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            return itemstack1.getCount() + itemstack.getCount() <= maxStackSize && itemstack1.getCount() + itemstack.getCount() <= itemstack1.getMaxStackSize() ? true : itemstack1.getCount() + itemstack.getCount() <= itemstack.getMaxStackSize();
        }
        return false;
    }

    private static boolean burn(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize, BlockEntityModuleFurnace furnace) {
        if (recipe != null && BlockEntityModuleFurnace.canBurn(registryAccess, recipe, inventory, maxStackSize, furnace)) {
            ItemStack itemstack = (ItemStack)inventory.get(0);
            ItemStack itemstack1 = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(furnace.getItem(0)), (HolderLookup.Provider)registryAccess);
            ItemStack itemstack2 = (ItemStack)inventory.get(2);
            if (itemstack2.isEmpty()) {
                inventory.set(2, (Object)itemstack1.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack2, (ItemStack)itemstack1)) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (itemstack.is(Blocks.WET_SPONGE.asItem()) && !((ItemStack)inventory.get(1)).isEmpty() && ((ItemStack)inventory.get(1)).is(Items.BUCKET)) {
                inventory.set(1, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        return fuel.getBurnTime(this.recipeType);
    }

    private static int getTotalCookTime(Level level, BlockEntityModuleFurnace blockEntity) {
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(blockEntity.getItem(0));
        return blockEntity.quickCheck.getRecipeFor((RecipeInput)singlerecipeinput, level).map(p_300840_ -> ((AbstractCookingRecipe)p_300840_.value()).getCookingTime()).orElse(200);
    }

    public static boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(null) > 0;
    }

    public int[] getSlotsForFace(Direction directionIn) {
        if (directionIn == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return directionIn == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean canPlaceItemThroughFace(int indexIn, ItemStack stackIn, @Nullable Direction directionIn) {
        return this.canPlaceItem(indexIn, stackIn);
    }

    public boolean canTakeItemThroughFace(int indexIn, ItemStack stackIn, Direction directionIn) {
        Item item;
        return directionIn != Direction.DOWN || indexIn != 1 || (item = stackIn.getItem()) == Items.WATER_BUCKET || item == Items.BUCKET;
    }

    public int getContainerSize() {
        return this.inventoryItems.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventoryItems) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int indexIn) {
        return (ItemStack)this.inventoryItems.get(indexIn);
    }

    public ItemStack removeItem(int indexIn, int countIn) {
        return ContainerHelper.removeItem(this.inventoryItems, (int)indexIn, (int)countIn);
    }

    public ItemStack removeItemNoUpdate(int indexIn) {
        return ContainerHelper.takeItem(this.inventoryItems, (int)indexIn);
    }

    public void setItem(int indexIn, ItemStack stackIn) {
        ItemStack itemstack = (ItemStack)this.inventoryItems.get(indexIn);
        boolean flag = !stackIn.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stackIn);
        this.inventoryItems.set(indexIn, (Object)stackIn);
        stackIn.limitSize(this.getMaxStackSize(stackIn));
        if (indexIn == 0 && !flag) {
            this.cookingTotalTime = BlockEntityModuleFurnace.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player playerIn) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return playerIn.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.inventoryItems.get(1);
        return stack.getBurnTime(this.recipeType) > 0 || stack.is(Items.BUCKET) && !itemstack.is(Items.BUCKET);
    }

    public void clearContent() {
        this.inventoryItems.clear();
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.id();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> items) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            player.triggerRecipeCrafted(recipeholder, this.inventoryItems);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(p_300839_ -> {
                list.add(p_300839_);
                BlockEntityModuleFurnace.createExperience((Level)level, popVec, entry.getIntValue(), ((AbstractCookingRecipe)p_300839_.value()).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(Level worldIn, Vec3 posIn, int craftedAmount, float experience) {
        int i = Mth.floor((float)((float)craftedAmount * experience));
        float f = Mth.frac((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.getExperienceValue((int)i);
            i -= j;
            worldIn.addFreshEntity((Entity)new ExperienceOrb(worldIn, posIn.x, posIn.y, posIn.z, j));
        }
    }

    public void fillStackedContents(StackedContents itemHelperIn) {
        for (ItemStack itemstack : this.inventoryItems) {
            itemHelperIn.accountStack(itemstack);
        }
    }

    public EnumUIMode getUIMode() {
        return this.uiMode;
    }

    public void setUIMode(EnumUIMode modeIn) {
        this.uiMode = modeIn;
    }

    public void cycleUIMode() {
        this.uiMode = EnumUIMode.getNextStateFromState((EnumUIMode)this.uiMode);
    }

    public EnumUIHelp getUIHelp() {
        return this.uiHelp;
    }

    public void setUIHelp(EnumUIHelp modeIn) {
        this.uiHelp = modeIn;
    }

    public void cycleUIHelp() {
        this.uiHelp = EnumUIHelp.getNextStateFromState((EnumUIHelp)this.uiHelp);
    }

    public EnumUILock getUILock() {
        return this.uiLock;
    }

    public void setUILock(EnumUILock modeIn) {
        this.uiLock = modeIn;
    }

    public void cycleUILock() {
        this.uiLock = EnumUILock.getNextStateFromState((EnumUILock)this.uiLock);
    }

    public void setOwner(Player playerIn) {
    }

    public boolean canPlayerAccess(Player playerIn) {
        if (this.getUILock().equals((Object)EnumUILock.PUBLIC)) {
            return true;
        }
        return this.getPocket().checkIfOwner(playerIn);
    }

    public boolean checkIfOwner(Player playerIn) {
        return this.getPocket().checkIfOwner(playerIn);
    }
}

