/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block.entity;

import com.tcn.cosmoslibrary.common.blockentity.CosmosBlockEntityUpdateable;
import com.tcn.cosmoslibrary.common.capability.IFluidCapBE;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.enums.EnumGenerationMode;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUILock;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.IFluidStorage;
import com.tcn.cosmoslibrary.common.interfaces.block.IBlockInteract;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUILockable;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectFluidTankCustom;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleGenerator;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlockEntityModuleGenerator
extends CosmosBlockEntityUpdateable
implements IBlockInteract,
WorldlyContainer,
MenuProvider,
Nameable,
IFluidHandler,
IFluidStorage,
IBEUIMode,
IBEUILockable,
IFluidCapBE {
    private NonNullList<ItemStack> inventoryItems = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private Pocket pocket;
    private int update = 0;
    private int burnTime;
    private int lastBurnTime = 1;
    private int cookTime;
    private int fluidBurnTime;
    private int fluidLastBurnTime = 1;
    private int fluidCookTime;
    private int generationRate = 0;
    private EnumGenerationMode generationMode = EnumGenerationMode.BURNABLE_ITEM;
    private ObjectFluidTankCustom internalTank = new ObjectFluidTankCustom(new FluidTank(64000), 0);
    private EnumUIMode uiMode = EnumUIMode.DARK;
    private EnumUIHelp uiHelp = EnumUIHelp.HIDDEN;
    private EnumUILock uiLock = EnumUILock.PRIVATE;
    private final int BUCKET_IN_SLOT = 1;
    private final int BUCKET_OUT_SLOT = 2;
    public final ContainerData dataAccess = new ContainerData(){

        public int get(int indexIn) {
            switch (indexIn) {
                case 0: {
                    return BlockEntityModuleGenerator.this.burnTime;
                }
                case 1: {
                    return BlockEntityModuleGenerator.this.cookTime;
                }
                case 2: {
                    return BlockEntityModuleGenerator.this.generationRate;
                }
                case 3: {
                    return BlockEntityModuleGenerator.this.fluidBurnTime;
                }
                case 4: {
                    return BlockEntityModuleGenerator.this.fluidCookTime;
                }
            }
            return 0;
        }

        public void set(int indexIn, int valueIn) {
            switch (indexIn) {
                case 0: {
                    BlockEntityModuleGenerator.this.burnTime = valueIn;
                    break;
                }
                case 1: {
                    BlockEntityModuleGenerator.this.cookTime = valueIn;
                    break;
                }
                case 2: {
                    BlockEntityModuleGenerator.this.generationRate = valueIn;
                    break;
                }
                case 3: {
                    BlockEntityModuleGenerator.this.fluidBurnTime = valueIn;
                    break;
                }
                case 4: {
                    BlockEntityModuleGenerator.this.fluidCookTime = valueIn;
                }
                default: {
                    return;
                }
            }
        }

        public int getCount() {
            return 5;
        }
    };

    public BlockEntityModuleGenerator(BlockPos posIn, BlockState stateIn) {
        super((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_GENERATOR.get(), posIn, stateIn);
    }

    public Pocket getPocket() {
        if (this.level.isClientSide) {
            return this.pocket;
        }
        return StorageManager.getPocketFromChunkPosition(this.getLevel(), CosmosChunkPos.scaleToChunkPos((BlockPos)this.getBlockPos()));
    }

    public void sendUpdates(boolean update) {
        super.sendUpdates(update);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.getPocket() != null) {
            this.getPocket().writeToNBT(compound, provider);
        }
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        compound.putInt("generation_mode", this.generationMode.getIndex());
        this.internalTank.writeToNBT(compound);
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
        compound.putInt("cookTime", this.cookTime);
        compound.putInt("burnTime", this.burnTime);
        compound.putInt("lastBurnTime", this.lastBurnTime);
        compound.putInt("generationRate", this.generationRate);
        compound.putInt("fluidCookTime", this.fluidCookTime);
        compound.putInt("fluidBurnTime", this.fluidBurnTime);
        compound.putInt("fluidLastBurnTime", this.fluidLastBurnTime);
    }

    public void saveToItemStack(ItemStack stackIn, HolderLookup.Provider provider) {
        CompoundTag compound = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        compound.putInt("generation_mode", this.generationMode.getIndex());
        this.internalTank.writeToNBT(compound);
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
        compound.putInt("cookTime", this.cookTime);
        compound.putInt("burnTime", this.burnTime);
        compound.putInt("lastBurnTime", this.lastBurnTime);
        compound.putInt("generationRate", this.generationRate);
        compound.putInt("fluidCookTime", this.fluidCookTime);
        compound.putInt("fluidBurnTime", this.fluidBurnTime);
        compound.putInt("fluidLastBurnTime", this.fluidLastBurnTime);
        stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (PocketUtil.hasPocketKey(compound)) {
            this.pocket = Pocket.readFromNBT(compound, provider);
        }
        this.inventoryItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        this.generationMode = EnumGenerationMode.getStateFromIndex((int)compound.getInt("generation_mode"));
        this.internalTank = ObjectFluidTankCustom.readFromNBT((CompoundTag)compound);
        this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
        this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
        this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
        this.cookTime = compound.getInt("cookTime");
        this.burnTime = compound.getInt("burnTime");
        this.lastBurnTime = compound.getInt("lastBurnTime");
        this.generationRate = compound.getInt("generationRate");
        this.fluidCookTime = compound.getInt("fluidCookTime");
        this.fluidBurnTime = compound.getInt("fluidBurnTime");
        this.fluidLastBurnTime = compound.getInt("fluidLastBurnTime");
    }

    public void loadFromItemStack(ItemStack stackIn, HolderLookup.Provider provider) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag();
            this.inventoryItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
            this.generationMode = EnumGenerationMode.getStateFromIndex((int)compound.getInt("generation_mode"));
            this.internalTank = ObjectFluidTankCustom.readFromNBT((CompoundTag)compound);
            this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
            this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
            this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
            this.cookTime = compound.getInt("cookTime");
            this.burnTime = compound.getInt("burnTime");
            this.lastBurnTime = compound.getInt("lastBurnTime");
            this.fluidCookTime = compound.getInt("fluidCookTime");
            this.fluidBurnTime = compound.getInt("fluidBurnTime");
            this.fluidLastBurnTime = compound.getInt("fluidLastBurnTime");
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        CompoundTag tag_ = pkt.getTag();
        this.handleUpdateTag(tag_, provider);
        this.sendUpdates(true);
    }

    public void onLoad() {
    }

    public static void tick(Level levelIn, BlockPos posIn, BlockState stateIn, BlockEntityModuleGenerator entityIn) {
        boolean flag;
        entityIn.checkFluidSlots();
        if (entityIn.burnTime > 0) {
            --entityIn.burnTime;
        }
        if (entityIn.fluidBurnTime > 0) {
            --entityIn.fluidBurnTime;
        }
        if (entityIn.getGenerationMode().equals((Object)EnumGenerationMode.BURNABLE_ITEM)) {
            entityIn.generationRate = 500;
            ItemStack burnStack = entityIn.getItem(0);
            int burnTime = 0;
            if (!entityIn.getItem(0).isEmpty()) {
                burnTime = burnStack.getBurnTime(null);
            }
            if (entityIn.burnTime <= 0 && entityIn.getPocket().getEnergyStored() < entityIn.getPocket().getMaxEnergyStored()) {
                entityIn.burnTime = burnTime;
                if (burnTime > 0) {
                    entityIn.lastBurnTime = burnTime;
                }
            }
            if (entityIn.burnTime > 0) {
                ++entityIn.cookTime;
                if (entityIn.getPocket().getEnergyStored() < entityIn.getPocket().getMaxEnergyStored()) {
                    if (entityIn.getPocket().receiveEnergy(entityIn.generationRate, true) > 0) {
                        entityIn.getPocket().receiveEnergy(entityIn.generationRate, false);
                    }
                    if (entityIn.cookTime == 1) {
                        entityIn.getItem(0).shrink(1);
                        entityIn.sendUpdates(true);
                    }
                }
                if (entityIn.cookTime == burnTime) {
                    entityIn.sendUpdates(true);
                    entityIn.cookTime = 0;
                }
            } else {
                entityIn.cookTime = 0;
            }
        } else if (entityIn.getGenerationMode().equals((Object)EnumGenerationMode.BURNABLE_FLUID)) {
            entityIn.generationRate = 1000;
            int burnTime = 0;
            if (entityIn.getCurrentFluidAmount() > 0) {
                burnTime = 20000;
            }
            if (entityIn.fluidBurnTime <= 0 && entityIn.getPocket().getEnergyStored() < entityIn.getPocket().getMaxEnergyStored()) {
                entityIn.fluidBurnTime = burnTime;
                if (burnTime > 0) {
                    entityIn.fluidLastBurnTime = burnTime;
                }
            }
            if (entityIn.fluidBurnTime > 0) {
                ++entityIn.fluidCookTime;
                if (entityIn.getPocket().getEnergyStored() < entityIn.getPocket().getMaxEnergyStored()) {
                    if (entityIn.getPocket().receiveEnergy(entityIn.generationRate, true) > 0) {
                        entityIn.getPocket().receiveEnergy(entityIn.generationRate, false);
                    }
                    if (entityIn.fluidCookTime == 1 && !entityIn.drain(1000, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                        entityIn.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        entityIn.sendUpdates(true);
                    }
                }
                if (entityIn.fluidCookTime == 20000) {
                    entityIn.sendUpdates(true);
                    entityIn.fluidCookTime = 0;
                }
            } else {
                entityIn.fluidCookTime = 0;
            }
        }
        boolean bl = flag = entityIn.update > 0;
        if (flag) {
            --entityIn.update;
        } else {
            entityIn.update = 20;
            entityIn.sendUpdates(true);
        }
    }

    public void attack(BlockState state, Level levelIn, BlockPos pos, Player playerIn) {
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level levelIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        this.setChanged();
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        if (PocketUtil.isDimensionEqual(levelIn, PocketsDimensionManager.POCKET_WORLD)) {
            Pocket pocketIn = this.getPocket();
            if (pocketIn != null) {
                if (!playerIn.isShiftKeyDown()) {
                    if (levelIn.isClientSide) {
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                        if (this.canPlayerAccess(playerIn)) {
                            serverPlayer.openMenu((MenuProvider)this, packetBuffer -> packetBuffer.writeBlockPos(pos));
                            return ItemInteractionResult.SUCCESS;
                        }
                        CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                        return ItemInteractionResult.FAIL;
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                if (CosmosUtil.handEmpty((Player)playerIn)) {
                    pocketIn.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                if (CosmosUtil.holdingWrench((Player)playerIn)) {
                    if (pocketIn.checkIfOwner(playerIn)) {
                        ItemStack stack = new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_GENERATOR.get());
                        this.saveToItemStack(stack, (HolderLookup.Provider)levelIn.registryAccess());
                        levelIn.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState());
                        levelIn.removeBlockEntity(pos);
                        CosmosUtil.addStack((Level)levelIn, (Player)playerIn, (ItemStack)stack);
                        pocketIn.removeUpdateable(pos);
                        return ItemInteractionResult.SUCCESS;
                    }
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                    return ItemInteractionResult.FAIL;
                }
            } else {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
                return ItemInteractionResult.FAIL;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level levelIn, BlockPos posIn, Player playerIn, BlockHitResult hit) {
        return InteractionResult.FAIL;
    }

    public void clearContent() {
    }

    public boolean canPlaceItemThroughFace(int arg0, ItemStack arg1, Direction arg2) {
        return false;
    }

    public boolean canTakeItemThroughFace(int arg0, ItemStack arg1, Direction arg2) {
        return false;
    }

    public int getContainerSize() {
        return 64;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventoryItems.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        this.setChanged();
        return ContainerHelper.removeItem(this.inventoryItems, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventoryItems, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventoryItems.set(index, (Object)stack);
        if (stack.getCount() > this.getContainerSize()) {
            stack.setCount(this.getContainerSize());
        }
        this.setChanged();
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventoryItems) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int[] getSlotsForFace(Direction arg0) {
        return new int[]{0, 0, 0, 0, 0, 0};
    }

    public Component getDisplayName() {
        return ComponentHelper.title((String)"dimensionalpocketsii.gui.generator");
    }

    public AbstractContainerMenu createMenu(int idIn, Inventory playerInventoryIn, Player playerIn) {
        return new ContainerModuleGenerator(idIn, playerInventoryIn, (Container)this, this.dataAccess, ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()), this.getBlockPos());
    }

    public EnumGenerationMode getGenerationMode() {
        return this.generationMode;
    }

    public boolean getGenerationModeValue() {
        return this.generationMode.getValue();
    }

    public void setGenerationMode(EnumGenerationMode state) {
        this.generationMode = state;
        this.sendUpdates(true);
    }

    public void setGenerationMode(boolean change) {
        this.generationMode = EnumGenerationMode.getStateFromValue((boolean)change);
        this.sendUpdates(true);
    }

    public void cycleGenerationMode() {
        this.setGenerationMode(EnumGenerationMode.getOpposite((EnumGenerationMode)this.generationMode));
        this.sendUpdates(true);
    }

    public Component getName() {
        return ComponentHelper.title((String)"dimensionalpocketsii.gui.generator");
    }

    public int getFluidLevelScaled(int one) {
        int cap = this.getFluidTankCapacity() > 0 ? this.getFluidTankCapacity() : 1;
        float scaled = this.getCurrentFluidAmount() * one / cap;
        if (scaled == 0.0f && this.getCurrentFluidAmount() > 0) {
            return 1;
        }
        return (int)scaled;
    }

    public int getCurrentFluidAmount() {
        return this.internalTank.getFluidTank().getFluidAmount();
    }

    public Fluid getCurrentStoredFluid() {
        this.updateFluidFillLevel();
        if (!this.isFluidTankEmpty()) {
            return this.internalTank.getFluidTank().getFluid().getFluid();
        }
        return null;
    }

    public String getCurrentStoredFluidName() {
        if (this.isFluidTankEmpty()) {
            return "Empty";
        }
        return this.internalTank.getFluidTank().getFluid().getTranslationKey();
    }

    public boolean isFluidTankEmpty() {
        return this.internalTank.getFluidTank().getFluidAmount() == 0;
    }

    public int getFluidTankCapacity() {
        return this.internalTank.getFluidTank().getCapacity();
    }

    public int getFluidFillLevel() {
        return this.internalTank.getFillLevel();
    }

    public void setFluidFillLevel(int set) {
        this.internalTank.setFillLevel(set);
    }

    public void updateFluidFillLevel() {
        if (!this.isFluidTankEmpty()) {
            if (this.getFluidLevelScaled(16) == 0) {
                this.internalTank.setFillLevel(1);
            } else {
                this.internalTank.setFillLevel(this.getFluidLevelScaled(16));
            }
        } else {
            this.internalTank.setFillLevel(0);
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.isFluidValid(0, resource)) {
            this.updateFluidFillLevel();
            return this.internalTank.getFluidTank().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        this.updateFluidFillLevel();
        return this.internalTank.getFluidTank().drain(resource.getAmount(), doDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        this.updateFluidFillLevel();
        return this.internalTank.getFluidTank().drain(maxDrain, doDrain);
    }

    public boolean canFill(Direction from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(Direction from, Fluid fluid) {
        return true;
    }

    public FluidTank getFluidTank() {
        return this.internalTank.getFluidTank();
    }

    public void setFluidTank(FluidTank tank) {
        this.internalTank.setFluidTank(tank);
    }

    public void emptyFluidTank() {
        this.internalTank.getFluidTank().setFluid(FluidStack.EMPTY);
    }

    public void checkFluidSlots() {
        if (!this.getLevel().isClientSide() && !this.getItem(1).isEmpty()) {
            ItemStack fillStack;
            Optional fluidStack = FluidUtil.getFluidContained((ItemStack)this.getItem(1));
            if (fluidStack.isPresent()) {
                int amount;
                FluidStack fluid = (FluidStack)fluidStack.get();
                if (fluid != null && this.isFluidValid(0, fluid) && fluid.getAmount() > 0 && (amount = this.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) == fluid.getAmount()) {
                    if (this.getItem(2).getItem().equals(FluidUtil.tryEmptyContainer((ItemStack)this.getItem((int)1), (IFluidHandler)this.getTank(), (int)amount, null, (boolean)false).result.getItem()) && this.getItem(2).getCount() < this.getItem(2).getMaxStackSize()) {
                        this.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        this.getItem(1).shrink(1);
                        this.getItem(2).grow(1);
                    }
                    if (this.getItem(2).isEmpty()) {
                        this.setItem(2, FluidUtil.tryEmptyContainer((ItemStack)this.getItem((int)1), (IFluidHandler)this.getTank(), (int)amount, null, (boolean)true).result);
                        this.getItem(1).shrink(1);
                    }
                }
            } else if (this.getCurrentFluidAmount() > 0 && this.getItem(2).isEmpty() && !(fillStack = FluidUtil.tryFillContainer((ItemStack)this.getItem((int)1), (IFluidHandler)this.getTank(), (int)this.getCurrentFluidAmount(), null, (boolean)true).result).isEmpty()) {
                this.setItem(2, fillStack);
                this.getItem(1).shrink(1);
                this.getPocket().updateFluidFillLevel();
            }
            this.sendUpdates(true);
        }
    }

    public int getFluidCapacity() {
        return this.internalTank.getFluidTank().getCapacity();
    }

    public FluidTank getTank() {
        return this.internalTank.getFluidTank();
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.internalTank.getFluidTank().getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.internalTank.getFluidTank().getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return stack.getFluid().getFluidType().getTemperature() >= 1000;
    }

    public int getBurnTimeScaled(int scale) {
        if (this.getGenerationMode().equals((Object)EnumGenerationMode.BURNABLE_ITEM)) {
            return this.burnTime * scale / (this.lastBurnTime + 1);
        }
        return this.fluidBurnTime * scale / (this.fluidLastBurnTime + 1);
    }

    public EnumUIMode getUIMode() {
        return this.uiMode;
    }

    public void setUIMode(EnumUIMode modeIn) {
        this.uiMode = modeIn;
    }

    public void cycleUIMode() {
        this.uiMode = EnumUIMode.getNextStateFromState((EnumUIMode)this.uiMode);
    }

    public EnumUIHelp getUIHelp() {
        return this.uiHelp;
    }

    public void setUIHelp(EnumUIHelp modeIn) {
        this.uiHelp = modeIn;
    }

    public void cycleUIHelp() {
        this.uiHelp = EnumUIHelp.getNextStateFromState((EnumUIHelp)this.uiHelp);
    }

    public EnumUILock getUILock() {
        return this.uiLock;
    }

    public void setUILock(EnumUILock modeIn) {
        this.uiLock = modeIn;
    }

    public void cycleUILock() {
        this.uiLock = EnumUILock.getNextStateFromState((EnumUILock)this.uiLock);
    }

    public void setOwner(Player playerIn) {
    }

    public boolean canPlayerAccess(Player playerIn) {
        if (this.getUILock().equals((Object)EnumUILock.PUBLIC)) {
            return true;
        }
        return this.getPocket().checkIfOwner(playerIn);
    }

    public boolean checkIfOwner(Player playerIn) {
        return this.getPocket().checkIfOwner(playerIn);
    }

    public IFluidHandler getFluidCapability(Direction directionIn) {
        return null;
    }
}

