/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.dimensionalpocketsii.pocket.core.gson.PocketChunkInfo;
import java.lang.reflect.Type;

public class GsonAdapterPocketChunkInfo
implements JsonSerializer<PocketChunkInfo>,
JsonDeserializer<PocketChunkInfo> {
    public PocketChunkInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        JsonObject pos = object.getAsJsonObject("pos");
        boolean singleChunk = object.get("single_chunk").getAsBoolean();
        int x = pos.get("x").getAsInt();
        int z = pos.get("z").getAsInt();
        return new PocketChunkInfo(new CosmosChunkPos(x, z), singleChunk);
    }

    public JsonElement serialize(PocketChunkInfo src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        JsonObject pos = new JsonObject();
        object.addProperty("single_chunk", Boolean.valueOf(src.isSingleChunk()));
        pos.addProperty("x", (Number)src.getDominantChunk().getX());
        pos.addProperty("z", (Number)src.getDominantChunk().getZ());
        object.add("pos", (JsonElement)pos);
        return object;
    }
}

