/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.tcn.dimensionalpocketsii.DimensionalPockets;
import java.lang.reflect.Type;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GsonAdapterPocketItemsList
implements JsonSerializer<NonNullList<ItemStack>>,
JsonDeserializer<NonNullList<ItemStack>> {
    public NonNullList<ItemStack> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitive object = null;
        try {
            object = json.getAsJsonPrimitive();
        }
        catch (IllegalStateException e) {
            DimensionalPockets.CONSOLE.warning((Object)"ItemList Legacy Check FAILED!");
        }
        if (object != null) {
            String string = object.getAsString();
            CompoundTag compoundOut = new CompoundTag();
            try {
                compoundOut = TagParser.parseTag((String)string);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int size = compoundOut.getInt("size");
            NonNullList list = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)compoundOut, (NonNullList)list, (HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess());
            return list;
        }
        DimensionalPockets.CONSOLE.info((Object)"Item list returned NULL. Implementing new ItemList.");
        NonNullList newList = NonNullList.withSize((int)48, (Object)ItemStack.EMPTY);
        return newList;
    }

    public JsonElement serialize(NonNullList<ItemStack> src, Type typeOfSrc, JsonSerializationContext context) {
        CompoundTag compound = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compound, src, (HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess());
        String nbt_string = compound.toString();
        return new JsonPrimitive(nbt_string);
    }
}

