/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.management;

import com.tcn.dimensionalpocketsii.pocket.core.block.BlockFocus;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketFocusTeleport;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PocketFocusManager {
    public static boolean isBlocked(BlockGetter world, BlockPos target) {
        return PocketFocusManager.validateTargets(world.getBlockState(target.above()), world.getBlockState(target.above(2)));
    }

    private static boolean validTarget(BlockState blockState) {
        return !blockState.isSolid();
    }

    private static boolean validateTargets(BlockState ... states) {
        return Arrays.stream(states).allMatch(PocketFocusManager::validTarget);
    }

    public static BlockFocus getElevator(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof BlockFocus) {
            BlockFocus elevator = (BlockFocus)block;
            return elevator;
        }
        return null;
    }

    public static boolean isBadTeleportPacket(PacketFocusTeleport packet, ServerPlayer player) {
        if (player == null || !player.isAlive()) {
            return true;
        }
        ServerLevel world = player.serverLevel();
        BlockPos fromPos = packet.fromPos();
        BlockPos toPos = packet.toPos();
        if (!world.isLoaded(fromPos) || !world.isLoaded(toPos)) {
            return true;
        }
        double distanceSq = player.distanceToSqr(Vec3.atCenterOf((Vec3i)fromPos.north()));
        if (distanceSq > 4.0) {
            return true;
        }
        if (fromPos.getX() != toPos.getX() || fromPos.getZ() != toPos.getZ()) {
            return true;
        }
        BlockFocus fromElevator = PocketFocusManager.getElevator(world.getBlockState(fromPos));
        BlockFocus toElevator = PocketFocusManager.getElevator(world.getBlockState(toPos));
        if (fromElevator == null || toElevator == null) {
            return true;
        }
        return !PocketFocusManager.isBlocked((BlockGetter)world, toPos);
    }
}

