/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.management;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.event.PortalEvent;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.system.primative.ObjectHolder2;
import com.tcn.dimensionalpocketsii.DimensionalPockets;
import com.tcn.dimensionalpocketsii.core.command.PocketCommands;
import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.AbstractBlockPocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockFocus;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockPocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockPocketEnhanced;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallBase;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallDoor;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallEdge;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallGlass;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallModule;
import com.tcn.dimensionalpocketsii.pocket.core.block.ItemBlockPocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.ItemBlockPocketEnhanced;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityFocus;
import com.tcn.dimensionalpocketsii.pocket.core.event.PocketBlockEvent;
import com.tcn.dimensionalpocketsii.pocket.core.event.PocketEvent;
import com.tcn.dimensionalpocketsii.pocket.core.gson.PocketChunkInfo;
import com.tcn.dimensionalpocketsii.pocket.core.management.PocketFocusManager;
import com.tcn.dimensionalpocketsii.pocket.core.registry.BackupManager;
import com.tcn.dimensionalpocketsii.pocket.core.registry.ChunkLoadingManager;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketFocusTeleport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="dimensionalpocketsii", bus=EventBusSubscriber.Bus.GAME)
public class PocketGameEventsManager {
    @OnlyIn(value=Dist.CLIENT)
    private static boolean lastSneaking;

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        RegistryAccess.Frozen provider = event.getServer().registryAccess();
        StorageManager.clearRegistry();
        StorageManager.loadRegistry((HolderLookup.Provider)provider);
        ChunkLoadingManager.loadFromStorage();
        DimensionalPockets.CONSOLE.startup((Object)"[Server Init] {server} <abouttostart> Server about to start.");
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        DimensionalPockets.CONSOLE.startup((Object)"[Server Init] {server} <starting> Server starting.");
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        DimensionalPockets.CONSOLE.startup((Object)"[Server Init] {server} <started> Server started.");
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        RegistryAccess.Frozen provider = event.getServer().registryAccess();
        StorageManager.saveRegistry((HolderLookup.Provider)provider);
        StorageManager.createBackup(BackupManager.BackupType.SYSTEM, (HolderLookup.Provider)provider);
        ChunkLoadingManager.saveToStorage();
        DimensionalPockets.CONSOLE.startup((Object)"[Server Stopping] {server} <stopping> Server stopping.");
    }

    @SubscribeEvent
    public static void onCommandRegistry(RegisterCommandsEvent event) {
        CommandDispatcher dispatcherIn = event.getDispatcher();
        PocketCommands.registerCommands((CommandDispatcher<CommandSourceStack>)dispatcherIn);
        DimensionalPockets.CONSOLE.startup((Object)"Command Registration complete.");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onInputEvent(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator() || !player.isAlive() || player.input == null) {
            return;
        }
        boolean sneaking = player.input.shiftKeyDown;
        if (lastSneaking != sneaking) {
            lastSneaking = sneaking;
            if (sneaking) {
                PocketGameEventsManager.tryTeleport(player, Direction.DOWN);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onJumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            if (entity.level().isClientSide()) {
                PocketGameEventsManager.tryTeleport((LocalPlayer)playerEntity, Direction.UP);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void tryTeleport(LocalPlayer player, Direction facing) {
        block3: {
            Level world = player.getCommandSenderWorld();
            BlockPos fromPos = PocketGameEventsManager.getOriginFocus(player);
            if (fromPos == null) {
                return;
            }
            BlockPos.MutableBlockPos toPos = fromPos.mutable();
            BlockEntity entity = world.getBlockEntity(fromPos);
            while (true) {
                toPos.setY(toPos.getY() + facing.getStepY());
                if (world.isOutsideBuildHeight((BlockPos)toPos) || Math.abs(toPos.getY() - fromPos.getY()) > PocketsConfigManager.getInstance().getFocusJumpRange()) break block3;
                BlockFocus focus = PocketFocusManager.getElevator(world.getBlockState((BlockPos)toPos));
                BlockEntity toEntity = world.getBlockEntity((BlockPos)toPos);
                if (focus == null || !PocketFocusManager.isBlocked((BlockGetter)world, (BlockPos)toPos) || !(entity instanceof BlockEntityFocus)) continue;
                BlockEntityFocus focusEntityFrom = (BlockEntityFocus)entity;
                if (!(toEntity instanceof BlockEntityFocus)) continue;
                BlockEntityFocus focusEntityTo = (BlockEntityFocus)toEntity;
                Pocket pocket = focusEntityTo.getPocket();
                if (pocket != null && toPos.getY() == focusEntityTo.getPocket().getInternalHeight()) {
                    return;
                }
                if (focusEntityFrom.getJumpEnabled() && focusEntityTo.getJumpEnabled()) break;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new PacketFocusTeleport(fromPos, (BlockPos)toPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BlockPos getOriginFocus(LocalPlayer player) {
        Level world = player.getCommandSenderWorld();
        BlockPos pos = new BlockPos((Vec3i)player.blockPosition());
        for (int i = 0; i < 3; ++i) {
            if (PocketFocusManager.getElevator(world.getBlockState(pos)) != null && PocketFocusManager.isBlocked((BlockGetter)world, pos)) {
                return pos;
            }
            pos = pos.below();
        }
        return null;
    }

    @SubscribeEvent
    public static void onPocketBlockPlacedEvent(PocketBlockEvent.PlacePocketBlock event) {
    }

    @SubscribeEvent
    public static void onPocketBlockPickupEvent(PocketBlockEvent.PickupPocketBlock event) {
    }

    @SubscribeEvent
    public static void onPocketGeneratedEvent(PocketEvent.GeneratePocketEvent event) {
    }

    @SubscribeEvent
    public static void onPortalTravelEvent(PortalEvent.PortalTravel event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        BlockPos pos = event.getDestPos();
        CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos);
        ResourceLocation destDimension = event.getDestDimension();
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)destDimension);
        if (dimension.equals(PocketsDimensionManager.POCKET_WORLD) && entity instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)entity;
            Pocket pocket = StorageManager.getPocketFromChunkPosition(level, chunkPos);
            if (!pocket.checkIfPlayerCanShift((Player)playerEntity, EnumShiftDirection.GENERIC)) {
                if (!entity.level().isClientSide()) {
                    DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <cosmosportals:portaltravel> { Player: '" + playerEntity.getDisplayName().getString() + "', UUID: '" + String.valueOf(playerEntity.getUUID()) + "' } tried to use a Portal to Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " } that has been locked by the Owner. This event has been cancelled."));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onContainerLinkEvent(PortalEvent.LinkContainer event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        BlockPos pos = event.getEntityPos();
        CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos);
        ResourceLocation destDimension = event.getDestDimension();
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)destDimension);
        if (dimension.equals(PocketsDimensionManager.POCKET_WORLD)) {
            Player playerEntity;
            Pocket pocket = StorageManager.getPocketFromChunkPosition(level, chunkPos);
            if (entity instanceof Player && !pocket.checkIfOwner(playerEntity = (Player)entity)) {
                if (!entity.level().isClientSide()) {
                    DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <cosmosportals:containerlink> { Player: '" + playerEntity.getDisplayName().getString() + "', UUID: '" + String.valueOf(playerEntity.getUUID()) + "' } tried to create a Dimension Container inside Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " } which they don't own. This event has been cancelled."));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEnderTeleportEvent(EntityTeleportEvent.EnderEntity event) {
        Entity entity = event.getEntity();
        if (entity != null) {
            Level world = entity.level();
            ResourceKey dimension = world.dimension();
            if (world != null && entity instanceof Player) {
                Player playerEntity = (Player)entity;
                if (dimension.equals(PocketsDimensionManager.POCKET_WORLD)) {
                    if (!world.isClientSide()) {
                        DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <enderteleport> { Player: '" + playerEntity.getDisplayName().getString() + "', UUID: '" + String.valueOf(playerEntity.getUUID()) + "' } tried to ender teleport. This event has been cancelled."));
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEnderPearlTeleportEvent(EntityTeleportEvent.EnderPearl event) {
        Entity entity = event.getEntity();
        if (entity != null) {
            Level world = entity.level();
            ResourceKey dimension = world.dimension();
            if (world != null && entity instanceof Player) {
                Player playerEntity = (Player)entity;
                if (!PocketsConfigManager.getInstance().getCanUseItems() && dimension.equals(PocketsDimensionManager.POCKET_WORLD)) {
                    if (!world.isClientSide()) {
                        DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <enderpearlteleport> { Player: '" + playerEntity.getDisplayName().getString() + "', UUID: '" + String.valueOf(playerEntity.getUUID()) + "' } tried to use an Ender Pearl. This event has been cancelled."));
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCommandEvent(CommandEvent event) {
        ParseResults results = event.getParseResults();
        CommandContextBuilder context = results.getContext();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String command = results.getReader().getString();
        Entity entity = source.getEntity();
        if (entity != null) {
            Level world = entity.level();
            ResourceKey dimension = world.dimension();
            if (world != null && dimension.equals(PocketsDimensionManager.POCKET_WORLD) && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                boolean cancelled = false;
                MinecraftServer serverIn = ServerLifecycleHooks.getCurrentServer();
                if (serverIn != null && dimension.equals(PocketsDimensionManager.POCKET_WORLD)) {
                    for (int i = 0; i < PocketsConfigManager.getInstance().getBlockedCommands().size(); ++i) {
                        String string;
                        String obj = PocketsConfigManager.getInstance().getBlockedCommands().get(i);
                        if (!(obj instanceof String) || !command.contains(string = obj)) continue;
                        if (serverIn.isSingleplayer()) {
                            if (PocketsConfigManager.getInstance().getCanUseCommands()) continue;
                            cancelled = true;
                            continue;
                        }
                        if (!serverPlayer.hasPermissions(PocketsConfigManager.getInstance().getOPLevel())) continue;
                        cancelled = false;
                    }
                }
                if (cancelled) {
                    event.setCanceled(true);
                    if (!world.isClientSide()) {
                        serverPlayer.sendSystemMessage((Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.error.command.usage").append(" \u00a7e /" + command));
                        DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <usecommand> { Player: '" + serverPlayer.getDisplayName().getString() + "', UUID: '" + String.valueOf(serverPlayer.getUUID()) + "' } tried to use command: { " + command + " }. This event has been cancelled."));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFallEvent(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity != null && entity instanceof Player) {
            Player playerEntity = (Player)entity;
            Level world = playerEntity.level();
            ResourceKey dimension = world.dimension();
            if (world != null && dimension.equals(PocketsDimensionManager.POCKET_WORLD)) {
                event.setDistance(0.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity != null && entity instanceof Player) {
            Level world = entity.level();
            ResourceKey dimension = world.dimension();
            if (world != null && dimension.equals(PocketsDimensionManager.POCKET_WORLD) && entity instanceof Player && entity.level().getDifficulty() == Difficulty.PEACEFUL) {
                event.setNewDamage(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyBlockEvent(LivingDestroyBlockEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity != null) {
            Level world = entity.level();
            ResourceKey dimension = world.dimension();
            if (world != null && dimension.equals(PocketsDimensionManager.POCKET_WORLD) && event.getState().getBlock() instanceof BlockWallBase) {
                event.setCanceled(true);
                world.sendBlockUpdated(event.getPos(), event.getState(), event.getState(), 3);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity != null) {
            Level world = entity.level();
            ResourceKey dimension = world.dimension();
            if (world != null && dimension.equals(PocketsDimensionManager.POCKET_WORLD) && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (entity.level().getDifficulty() == Difficulty.PEACEFUL) {
                    serverPlayer.setHealth(serverPlayer.getMaxHealth());
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevelEvent(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        EntityType entity_type = entity.getType();
        Level world = entity.level();
        ResourceKey dimension = world.dimension();
        MobCategory clazz = entity_type.getCategory();
        BlockPos pos = entity.blockPosition();
        CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos);
        if (!(entity instanceof Player) && dimension.equals(PocketsDimensionManager.POCKET_WORLD) && !world.isClientSide()) {
            Pocket pocket = StorageManager.getPocketFromChunkPosition(world, chunkPos);
            DimensionalPockets.CONSOLE.debug((Object)"HERE");
            if (pocket != null && clazz.equals((Object)MobCategory.MONSTER) && (!pocket.getHostileSpawnStateValue() || PocketsConfigManager.getInstance().getStopHostileSpawns())) {
                event.setCanceled(true);
            }
            if (entity_type.equals(EntityType.ELDER_GUARDIAN)) {
                event.setCanceled(true);
                DimensionalPockets.CONSOLE.debug((Object)"[Event Cancellation] <entityjoin> An Elder Guardian was attempted to spawn. This event has been cancelled.");
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        Entity entity = event.getEntityMounting();
        Entity mounted = event.getEntityBeingMounted();
        ResourceKey dimension = entity.level().dimension();
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            if (dimension.equals(PocketsDimensionManager.POCKET_WORLD) && (mounted.getType().equals(EntityType.MINECART) || mounted.getType().equals(EntityType.BOAT))) {
                if (!entity.level().isClientSide()) {
                    DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <entitymount> { Player: '" + playerEntity.getDisplayName().getString() + "', UUID: '" + String.valueOf(playerEntity.getUUID()) + "' } tried to mount entity: { " + String.valueOf(mounted) + " } This event has been cancelled."));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        ResourceKey dimension = entity.level().dimension();
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        ResourceLocation registry_name = ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.ITEM.getKey((Object)item).getNamespace(), (String)BuiltInRegistries.ITEM.getKey((Object)item).getPath());
        if (!PocketsConfigManager.getInstance().getCanUseItems() && entity instanceof Player) {
            Player playerEntity = entity;
            if (dimension.equals(PocketsDimensionManager.POCKET_WORLD)) {
                for (int i = 0; i < PocketsConfigManager.getInstance().getBlockedItems().size(); ++i) {
                    String[] split;
                    ResourceLocation string_location;
                    String string;
                    String obj = PocketsConfigManager.getInstance().getBlockedItems().get(i);
                    if (!(obj instanceof String) || !(string = obj).contains(":") || !registry_name.equals((Object)(string_location = ResourceLocation.fromNamespaceAndPath((String)(split = string.split(":"))[0], (String)split[1])))) continue;
                    if (!entity.level().isClientSide()) {
                        CosmosChatUtil.sendServerPlayerMessage((Player)playerEntity, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.error.item.usage"));
                        DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <rightclickitem> { Player: '" + playerEntity.getDisplayName().getString() + "', UUID: '" + String.valueOf(playerEntity.getUUID()) + "' } tried to right click a blacklised Item. This event has been cancelled."));
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUseItemEvent(LivingEntityUseItemEvent event) {
        LivingEntity entity = event.getEntity();
        ResourceKey dimension = entity.level().dimension();
        ItemStack stack = event.getItem();
        Item item = stack.getItem();
        ResourceLocation registry_name = ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.ITEM.getKey((Object)item).getNamespace(), (String)BuiltInRegistries.ITEM.getKey((Object)item).getPath());
        if (!PocketsConfigManager.getInstance().getCanUseItems() && entity instanceof Player) {
            Player playerEntity = (Player)entity;
            if (dimension.equals(PocketsDimensionManager.POCKET_WORLD)) {
                for (int i = 0; i < PocketsConfigManager.getInstance().getBlockedItems().size(); ++i) {
                    String[] split;
                    ResourceLocation string_location;
                    String string;
                    String obj = PocketsConfigManager.getInstance().getBlockedItems().get(i);
                    if (!(obj instanceof String) || !(string = obj).contains(":") || !registry_name.equals((Object)(string_location = ResourceLocation.fromNamespaceAndPath((String)(split = string.split(":"))[0], (String)split[1])))) continue;
                    if (!entity.level().isClientSide()) {
                        CosmosChatUtil.sendServerPlayerMessage((Player)playerEntity, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.error.item.usage"));
                        DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <useitem> { Player: '" + playerEntity.getDisplayName().getString() + "', UUID: '" + String.valueOf(playerEntity.getUUID()) + "' } tried to use a blacklised Item. This event has been cancelled."));
                    }
                    event.setDuration(0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockEntityPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        ResourceKey dimension = entity.level().dimension();
        BlockState state = event.getPlacedBlock();
        Block block = state.getBlock();
        ResourceLocation registry_name = ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.ITEM.getKey((Object)block.asItem()).getNamespace(), (String)BuiltInRegistries.ITEM.getKey((Object)block.asItem()).getPath());
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            if (!PocketsConfigManager.getInstance().getCanPlaceStructures() && dimension.equals(PocketsDimensionManager.POCKET_WORLD)) {
                for (int i = 0; i < PocketsConfigManager.getInstance().getBlockedStructures().size(); ++i) {
                    String[] split;
                    ResourceLocation string_location;
                    String string;
                    String obj = PocketsConfigManager.getInstance().getBlockedStructures().get(i);
                    if (!(obj instanceof String) || !(string = obj).contains(":") || !registry_name.equals((Object)(string_location = ResourceLocation.fromNamespaceAndPath((String)(split = string.split(":"))[0], (String)split[1])))) continue;
                    if (!entity.level().isClientSide()) {
                        CosmosChatUtil.sendServerPlayerMessage((Player)playerEntity, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.error.block.usage"));
                        DimensionalPockets.CONSOLE.debug((Object)("[Event Cancellation] <placeblock> Player: { " + String.valueOf(playerEntity.getDisplayName().getContents()) + " } tried to right click a blacklised Item. This event has been cancelled."));
                    }
                    event.setCanceled(true);
                }
            }
            if (block instanceof BlockPocket || block instanceof BlockPocketEnhanced) {
                CosmosChunkPos testPos;
                CosmosChunkPos pos;
                int z;
                int x;
                CompoundTag chunk_set;
                CompoundTag nbt_data;
                CompoundTag compound;
                ItemStack mainStack = playerEntity.getMainHandItem();
                ItemStack offHandStack = playerEntity.getOffhandItem();
                if ((mainStack.getItem() instanceof ItemBlockPocket || offHandStack.getItem() instanceof ItemBlockPocketEnhanced) && mainStack.has(DataComponents.CUSTOM_DATA) && (compound = ((CustomData)mainStack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("nbt_data")) {
                    nbt_data = compound.getCompound("nbt_data");
                    chunk_set = nbt_data.getCompound("chunk_set");
                    x = chunk_set.getInt("X");
                    z = chunk_set.getInt("Z");
                    pos = CosmosChunkPos.scaleToChunkPos((BlockPos)event.getPos());
                    if (pos.equals((Object)(testPos = new CosmosChunkPos(x, z)))) {
                        event.setCanceled(true);
                    }
                }
                if ((offHandStack.getItem() instanceof ItemBlockPocket || offHandStack.getItem() instanceof ItemBlockPocketEnhanced) && offHandStack.has(DataComponents.CUSTOM_DATA) && (compound = ((CustomData)offHandStack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("nbt_data")) {
                    nbt_data = compound.getCompound("nbt_data");
                    chunk_set = nbt_data.getCompound("chunk_set");
                    x = chunk_set.getInt("X");
                    z = chunk_set.getInt("Z");
                    pos = CosmosChunkPos.scaleToChunkPos((BlockPos)event.getPos());
                    if (pos.equals((Object)(testPos = new CosmosChunkPos(x, z)))) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        Player entity = event.getPlayer();
        if (entity != null) {
            Level world = entity.level();
            BlockPos pos = event.getPos();
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            ResourceKey dimension = world.dimension();
            if (world != null && dimension.equals(PocketsDimensionManager.POCKET_WORLD) && !PocketsConfigManager.getInstance().getCanDestroyWalls() && (block instanceof BlockWallBase || block instanceof BlockWallEdge || block instanceof BlockWallGlass || block instanceof BlockWallModule || block.equals(Blocks.BEDROCK) || block instanceof BlockFocus || block instanceof BlockWallDoor)) {
                for (Direction c : Direction.values()) {
                    BlockPos offset_pos = pos.offset(c.getNormal());
                    BlockState offset_state = world.getBlockState(offset_pos);
                    if (world.isEmptyBlock(offset_pos)) continue;
                    world.sendBlockUpdated(offset_pos, offset_state, offset_state, 3);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityPlaceBlockEvent(BlockEvent.EntityPlaceEvent event) {
        BlockState state = event.getPlacedBlock();
        Block block = state.getBlock();
        if (block instanceof AbstractBlockPocket) {
            ResourceKey dimension;
            ObjectHolder2<PocketChunkInfo, Pocket> info;
            Player playerEntity;
            Level level;
            AbstractBlockPocket blockPocket = (AbstractBlockPocket)block;
            Entity entity = event.getEntity();
            BlockPos pos = event.getPos();
            if (entity != null && entity instanceof Player && (level = (playerEntity = (Player)entity).level()) != null && (info = StorageManager.getChunkInfoForPocket((ResourceKey<Level>)(dimension = level.dimension()), pos)) != null) {
                PocketChunkInfo chunkInfo = (PocketChunkInfo)info.getFirst();
                if (blockPocket.getIsSingleChunk() != chunkInfo.isSingleChunk()) {
                    event.setCanceled(true);
                    if (((Pocket)info.getSecond()).getOwnerName().equals(entity.getDisplayName().getString())) {
                        entity.sendSystemMessage((Component)ComponentHelper.style((ComponentColour)ComponentColour.ORANGE, (String)"You cannot place a Pocket here, as there was a different one here before."));
                    }
                }
            }
        }
    }
}

