/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.registry;

import com.google.common.io.Files;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.system.io.CosmosIOHandler;
import com.tcn.dimensionalpocketsii.DimensionalPockets;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.gson.PocketChunkInfo;
import com.tcn.dimensionalpocketsii.pocket.core.registry.InterfaceManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class BackupManager {
    public static boolean createFullBackup(Map<PocketChunkInfo, Pocket> pocketRegistryIn, BackupType backupTypeIn, HolderLookup.Provider provider) {
        block5: {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            StringBuilder filePath = new StringBuilder();
            try {
                if (server == null) break block5;
                if (server.isSingleplayer()) {
                    filePath.append("saves/");
                }
                filePath.append(CosmosIOHandler.getServerLevelId((MinecraftServer)server) + "/dimpockets/backups/registry-backup" + (String)(backupTypeIn.getIncludeDate() ? " [" + CosmosUtil.getDateYMD((boolean)true, (String)"-") + "] " : " ") + (String)(backupTypeIn.getDescriptor() != "" ? "[" + backupTypeIn.getDescriptor() + "]" : "") + ".zip");
                File tempFile = BackupManager.saveToFile(pocketRegistryIn, "dimpockets/backups", "registry-backup", InterfaceManager.RegistryFileType.JSON, provider, true, true);
                CosmosIOHandler.createFile((File)tempFile);
                try {
                    ZipOutputStream zipOutStream = new ZipOutputStream(new FileOutputStream(filePath.toString()));
                    BackupManager.addEntry(zipOutStream, "pocketRegistry", InterfaceManager.RegistryFileType.DAT, BackupManager.saveToFile(pocketRegistryIn, "", "pocketRegistry", InterfaceManager.RegistryFileType.DAT, provider, true, true), true);
                    BackupManager.addEntry(zipOutStream, "pocketRegistry", InterfaceManager.RegistryFileType.JSON, BackupManager.saveToFile(pocketRegistryIn, "", "pocketRegistry", InterfaceManager.RegistryFileType.JSON, provider, true, true), true);
                    BackupManager.addEntry(zipOutStream, "pocketGenParameters", InterfaceManager.RegistryFileType.JSON, BackupManager.saveToFile(pocketRegistryIn, "", "pocketGenParameters", InterfaceManager.RegistryFileType.JSON, provider, true, true), true);
                    zipOutStream.close();
                    DimensionalPockets.CONSOLE.info((Object)"[Backup System] <createFullBackup> Full Backup created.");
                }
                catch (Exception e) {
                    DimensionalPockets.CONSOLE.fatal((Object)"[Backup System] <createFullBackup> Unable to create Backup. See stacktrace for more info:", (Throwable)e);
                }
                tempFile.delete();
                return true;
            }
            catch (Exception e) {
                DimensionalPockets.CONSOLE.fatal((Object)"[Backup System] <createFullBackup> Unable to create Backup. See stacktrace for more info:", (Throwable)e);
            }
        }
        return false;
    }

    public static File saveToFile(Map<PocketChunkInfo, Pocket> pocketRegistryIn, String folderName, String fileName, InterfaceManager.RegistryFileType fileType, HolderLookup.Provider provider, boolean includeSaveFolder, boolean backup) {
        return InterfaceManager.Registry.saveToFile(pocketRegistryIn, folderName, fileName, fileType, provider, includeSaveFolder, backup).get();
    }

    private static boolean addEntry(ZipOutputStream zipOutputStream, String entryPath, InterfaceManager.RegistryFileType fileType, File fileToAdd, boolean deleteFile) {
        try {
            zipOutputStream.putNextEntry(new ZipEntry(entryPath + fileType.getExtension()));
            Files.copy((File)fileToAdd, (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
            if (deleteFile) {
                fileToAdd.delete();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum BackupType {
        SYSTEM(0, true, true, "system"),
        USER(1, false, true, "user"),
        CONVERSION(2, true, false, "conversion"),
        UNKNOWN(-1, false, false, "unknown");

        private final int index;
        private final boolean automatic;
        private final boolean includeDate;
        private final String descriptor;

        private BackupType(int indexIn, boolean automaticIn, boolean includeDateIn, String descriptorIn) {
            this.index = indexIn;
            this.automatic = automaticIn;
            this.includeDate = includeDateIn;
            this.descriptor = descriptorIn;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean getAutomatic() {
            return this.automatic;
        }

        public boolean getIncludeDate() {
            return this.includeDate;
        }

        public String getDescriptor() {
            return this.descriptor;
        }
    }
}

