/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tcn.cosmoslibrary.common.enums.EnumGeneralAllowState;
import com.tcn.cosmoslibrary.common.enums.EnumGeneratedState;
import com.tcn.cosmoslibrary.common.enums.EnumLockState;
import com.tcn.cosmoslibrary.common.enums.EnumSideState;
import com.tcn.cosmoslibrary.common.enums.EnumTrapState;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.nbt.CosmosNBTIOHandler;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterBlockPosDimension;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterConnectionType;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterFluidTankCustom;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterGeneralAllowState;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterGeneratedState;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterItemStack;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterLockState;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterSideState;
import com.tcn.cosmoslibrary.registry.gson.GsonAdapterTrapState;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectBlockPosDimension;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectConnectionType;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectFluidTankCustom;
import com.tcn.cosmoslibrary.system.io.CosmosIOHandler;
import com.tcn.dimensionalpocketsii.DimensionalPockets;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.gson.GsonAdapterPocketChunkInfo;
import com.tcn.dimensionalpocketsii.pocket.core.gson.GsonAdapterPocketItemsList;
import com.tcn.dimensionalpocketsii.pocket.core.gson.PocketChunkInfo;
import com.tcn.dimensionalpocketsii.pocket.core.registry.BackupManager;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class InterfaceManager {
    public static File retrieveOrCreateFile(String folderName, String fileName, RegistryFileType fileTypeIn, boolean includeSaveFolder, boolean createFile) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        StringBuilder filePath = new StringBuilder();
        if (server != null) {
            if (includeSaveFolder && server.isSingleplayer()) {
                filePath.append("saves/");
            }
            filePath.append(CosmosIOHandler.getServerLevelId((MinecraftServer)server) + "/" + folderName + "/" + fileName + fileTypeIn.getExtension());
            File file = server.getFile(filePath.toString()).toFile();
            if (!file.exists() && createFile) {
                CosmosIOHandler.createFile((File)file);
            }
            return file;
        }
        return new File(".");
    }

    protected static enum RegistryFileType {
        JSON(0, "json", ".json", true),
        DAT(1, "dat", ".dat", false);

        private final int index;
        private final String name;
        private final String extension;
        private final boolean isPlainText;

        private RegistryFileType(int indexIn, String nameIn, String extensionIn, boolean isPlainTextIn) {
            this.index = indexIn;
            this.name = nameIn;
            this.extension = extensionIn;
            this.isPlainText = isPlainTextIn;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean isPlainText() {
            return this.isPlainText;
        }
    }

    public class GenerationParams {
        public GenerationParams(InterfaceManager this$0) {
        }

        public static boolean saveToFile(StorageManager.GenerationParameters pocketGenParameters) {
            boolean bl;
            File dataFile = InterfaceManager.retrieveOrCreateFile("dimpockets", "pocketGenParameters", RegistryFileType.JSON, true, true);
            FileWriter writer = new FileWriter(dataFile);
            try {
                GSON.LOADER.toJson((Object)pocketGenParameters, (Appendable)writer);
                writer.flush();
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <savePocketGenParams> Could not save pocketGenParams via [FileWriter]. See stacktrace for more info:", (Throwable)e);
                    return false;
                }
            }
            writer.close();
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static StorageManager.GenerationParameters loadFromFile() {
            try {
                File dataFile = InterfaceManager.retrieveOrCreateFile("dimpockets", "pocketGenParameters", RegistryFileType.JSON, true, true);
                if (!dataFile.exists()) return new StorageManager.GenerationParameters();
                try (FileReader dataReader = new FileReader(dataFile);){
                    StorageManager.GenerationParameters pocketGenParams = (StorageManager.GenerationParameters)GSON.LOADER.fromJson((Reader)dataReader, StorageManager.GenerationParameters.class);
                    dataReader.close();
                    if (pocketGenParams == null) return new StorageManager.GenerationParameters();
                    StorageManager.GenerationParameters generationParameters = pocketGenParams;
                    return generationParameters;
                }
                catch (Exception e) {
                    DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <loadPocketGenParams> Could not load pocketGenParams via [FileWriter]. See stacktrace for more info:", (Throwable)e);
                    return new StorageManager.GenerationParameters();
                }
            }
            catch (Exception e) {
                DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <loadPocketGenParams> Could not load pocketGenParams. See stacktrace for more info:", (Throwable)e);
            }
            return new StorageManager.GenerationParameters();
        }
    }

    public class LoadedRooms {
        public LoadedRooms(InterfaceManager this$0) {
        }

        public static Optional<File> saveToFile(ArrayList<CosmosChunkPos> loadedRoomsIn, RegistryFileType fileType) {
            return LoadedRooms.saveToFile(loadedRoomsIn, "dimpockets/data", "loaded_rooms", fileType, true, false);
        }

        public static Optional<File> saveToFile(ArrayList<CosmosChunkPos> loadedBlocksIn, String folderName, String fileName, RegistryFileType fileType, boolean includeSaveFolder, boolean backup) {
            return LoadedRooms.saveRaw(InterfaceManager.retrieveOrCreateFile(folderName, fileName, fileType, includeSaveFolder, true), loadedBlocksIn);
        }

        private static Optional<File> saveRaw(File fileIn, ArrayList<CosmosChunkPos> loadedBlocksIn) {
            CompoundTag tag = new CompoundTag();
            for (int i = 0; i < loadedBlocksIn.size(); ++i) {
                CosmosChunkPos pos = loadedBlocksIn.get(i);
                CompoundTag chunk = new CompoundTag();
                chunk.putInt("x", pos.getX());
                chunk.putInt("z", pos.getZ());
                tag.put(Integer.toString(i), (Tag)chunk);
            }
            tag.putInt("size", loadedBlocksIn.size());
            try {
                CosmosNBTIOHandler.write((CompoundTag)tag, (File)fileIn);
                return Optional.ofNullable(fileIn);
            }
            catch (Exception e) {
                DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <saveRegistryRaw> Could not save LoadedRooms {DAT}. See stacktrace for more info:", (Throwable)e);
                return Optional.empty();
            }
        }

        public static ArrayList<CosmosChunkPos> loadFromFile(RegistryFileType fileTypeIn) {
            return LoadedRooms.loadFromFile("dimpockets/data", "loaded_rooms", fileTypeIn);
        }

        public static ArrayList<CosmosChunkPos> loadFromFile(String folderName, String fileName, RegistryFileType fileTypeIn) {
            return LoadedRooms.loadRaw(InterfaceManager.retrieveOrCreateFile(folderName, fileName, fileTypeIn, true, true));
        }

        private static ArrayList<CosmosChunkPos> loadRaw(File fileIn) {
            ArrayList<CosmosChunkPos> loadedRooms = new ArrayList<CosmosChunkPos>();
            try {
                CompoundTag readTag = CosmosNBTIOHandler.read((File)fileIn);
                for (int i = 0; i < readTag.getInt("size"); ++i) {
                    CompoundTag chunkTag = readTag.getCompound(Integer.toString(i));
                    loadedRooms.add(new CosmosChunkPos(chunkTag.getInt("x"), chunkTag.getInt("z")));
                }
            }
            catch (Exception e) {
                DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <loadPocketRegistry> Could not load LoadedRooms {DAT}. See stacktrace for more info:", (Throwable)e);
            }
            return loadedRooms;
        }
    }

    public class LoadedBlocks {
        public LoadedBlocks(InterfaceManager this$0) {
        }

        public static Optional<File> saveToFile(Map<CosmosChunkPos, ObjectBlockPosDimension> loadedBlocksIn, RegistryFileType fileType) {
            return LoadedBlocks.saveToFile(loadedBlocksIn, "dimpockets/data", "loaded_blocks", fileType, true, false);
        }

        public static Optional<File> saveToFile(Map<CosmosChunkPos, ObjectBlockPosDimension> loadedBlocksIn, String folderName, String fileName, RegistryFileType fileType, boolean includeSaveFolder, boolean backup) {
            return LoadedBlocks.saveRaw(InterfaceManager.retrieveOrCreateFile(folderName, fileName, fileType, includeSaveFolder, true), loadedBlocksIn);
        }

        private static Optional<File> saveRaw(File fileIn, Map<CosmosChunkPos, ObjectBlockPosDimension> loadedBlocksIn) {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<CosmosChunkPos, ObjectBlockPosDimension> entry : loadedBlocksIn.entrySet()) {
                CompoundTag chunkTag = new CompoundTag();
                chunkTag.putLong("chunk", entry.getKey().toLong());
                tag.put(entry.getKey().getX() + ";" + entry.getKey().getZ(), (Tag)chunkTag);
                CompoundTag dimTag = new CompoundTag();
                entry.getValue().save(dimTag);
                chunkTag.put("dim", (Tag)dimTag);
            }
            try {
                CosmosNBTIOHandler.write((CompoundTag)tag, (File)fileIn);
                return Optional.ofNullable(fileIn);
            }
            catch (Exception e) {
                DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <saveRegistryRaw> Could not save LoadedBlocks {DAT}. See stacktrace for more info:", (Throwable)e);
                return Optional.empty();
            }
        }

        public static LinkedHashMap<CosmosChunkPos, ObjectBlockPosDimension> loadFromFile(RegistryFileType fileTypeIn) {
            return LoadedBlocks.loadFromFile("dimpockets/data", "loaded_blocks", fileTypeIn);
        }

        public static LinkedHashMap<CosmosChunkPos, ObjectBlockPosDimension> loadFromFile(String folderName, String fileName, RegistryFileType fileTypeIn) {
            return LoadedBlocks.loadRaw(InterfaceManager.retrieveOrCreateFile(folderName, fileName, fileTypeIn, true, true));
        }

        private static LinkedHashMap<CosmosChunkPos, ObjectBlockPosDimension> loadRaw(File fileIn) {
            LinkedHashMap<CosmosChunkPos, ObjectBlockPosDimension> loadedBlocks = new LinkedHashMap<CosmosChunkPos, ObjectBlockPosDimension>();
            try {
                try {
                    CompoundTag readTag = CosmosNBTIOHandler.read((File)fileIn);
                    for (String key : readTag.getAllKeys()) {
                        CompoundTag chunkTag = readTag.getCompound(key);
                        CosmosChunkPos chunk = new CosmosChunkPos(chunkTag.getLong("chunk"));
                        CompoundTag dimTag = chunkTag.getCompound("dim");
                        ObjectBlockPosDimension dim = ObjectBlockPosDimension.load((CompoundTag)dimTag);
                        loadedBlocks.put(chunk, dim);
                    }
                }
                catch (Exception readTag) {
                }
            }
            catch (Exception e) {
                DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <loadPocketRegistry> Could not load LoadedBlocks {DAT}. See stacktrace for more info:", (Throwable)e);
            }
            return loadedBlocks;
        }
    }

    public class Registry {
        public Registry(InterfaceManager this$0) {
        }

        public static Optional<File> saveToFile(Map<PocketChunkInfo, Pocket> pocketRegistryIn, RegistryFileType fileType, HolderLookup.Provider provider) {
            return Registry.saveToFile(pocketRegistryIn, "dimpockets", "pocketRegistry", fileType, provider, true, false);
        }

        public static Optional<File> saveToFile(Map<PocketChunkInfo, Pocket> pocketRegistryIn, String folderName, String fileName, RegistryFileType fileType, HolderLookup.Provider provider, boolean includeSaveFolder, boolean backup) {
            return Registry.saveRaw(InterfaceManager.retrieveOrCreateFile(folderName, fileName, fileType, includeSaveFolder, true), pocketRegistryIn, fileType, provider);
        }

        private static Optional<File> saveRaw(File fileIn, Map<PocketChunkInfo, Pocket> pocketRegistryIn, RegistryFileType fileTypeIn, HolderLookup.Provider provider) {
            if (fileTypeIn.isPlainText()) {
                Optional<File> optional;
                Collection<Pocket> values = pocketRegistryIn.values();
                Pocket[] tempArray = values.toArray(new Pocket[values.size()]);
                FileWriter writer = new FileWriter(fileIn);
                try {
                    GSON.LOADER.toJson((Object)tempArray, (Appendable)writer);
                    writer.flush();
                    optional = Optional.ofNullable(fileIn);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        DimensionalPockets.CONSOLE.fatal((Object)("[File System Error] <saveRegistryRaw> Could not save PocketRegistry {" + fileTypeIn.getExtension() + "} See stacktrace for more info:"), (Throwable)e);
                    }
                }
                writer.close();
                return optional;
            } else {
                Collection<Pocket> values = pocketRegistryIn.values();
                ArrayList<Pocket> array = new ArrayList<Pocket>(values);
                CompoundTag tag = new CompoundTag();
                tag.putInt("size", array.size());
                for (int i = 0; i < array.size(); ++i) {
                    Pocket pocket = array.get(i);
                    CompoundTag pocketTag = new CompoundTag();
                    pocket.writeToNBT(pocketTag, provider);
                    tag.put(Integer.toString(i), (Tag)pocketTag);
                }
                try {
                    CosmosNBTIOHandler.write((CompoundTag)tag, (File)fileIn);
                    return Optional.ofNullable(fileIn);
                }
                catch (Exception e) {
                    DimensionalPockets.CONSOLE.fatal((Object)("[File System Error] <saveRegistryRaw> Could not save PocketRegistry {" + fileTypeIn.getExtension() + "} See stacktrace for more info:"), (Throwable)e);
                }
            }
            return Optional.empty();
        }

        public static LinkedHashMap<PocketChunkInfo, Pocket> loadFromFile(RegistryFileType fileTypeIn, HolderLookup.Provider provider) {
            return Registry.loadFromFile("dimpockets", "pocketRegistry", fileTypeIn, provider, true);
        }

        public static LinkedHashMap<PocketChunkInfo, Pocket> loadFromFile(String folderName, String fileName, RegistryFileType fileTypeIn, HolderLookup.Provider provider, boolean broadcast) {
            File jsonFile;
            File loadedFile = InterfaceManager.retrieveOrCreateFile(folderName, fileName, fileTypeIn, true, false);
            if (!fileTypeIn.isPlainText() && !loadedFile.exists() && (jsonFile = InterfaceManager.retrieveOrCreateFile(folderName, fileName, RegistryFileType.JSON, true, false)).exists()) {
                CosmosIOHandler.createFile((File)loadedFile);
                LinkedHashMap<PocketChunkInfo, Pocket> freshRegistry = Registry.loadRaw(jsonFile, RegistryFileType.JSON, provider, true);
                BackupManager.createFullBackup(freshRegistry, BackupManager.BackupType.CONVERSION, provider);
                Registry.saveRaw(loadedFile, freshRegistry, fileTypeIn, provider);
                jsonFile.delete();
                return freshRegistry;
            }
            return Registry.loadRaw(InterfaceManager.retrieveOrCreateFile(folderName, fileName, fileTypeIn, true, true), fileTypeIn, provider, broadcast);
        }

        private static LinkedHashMap<PocketChunkInfo, Pocket> loadRaw(File fileIn, RegistryFileType fileTypeIn, HolderLookup.Provider provider, boolean broadcast) {
            LinkedHashMap<PocketChunkInfo, Pocket> newPocketRegistry = new LinkedHashMap<PocketChunkInfo, Pocket>();
            if (fileTypeIn.isPlainText()) {
                Pocket[] pocketArray = null;
                try (FileReader reader = new FileReader(fileIn);){
                    pocketArray = (Pocket[])GSON.LOADER.fromJson((Reader)reader, Pocket[].class);
                    reader.close();
                }
                catch (Exception e) {
                    DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <loadPocketRegistry> Could not load PocketRegistry. See stacktrace for more info:", (Throwable)e);
                }
                if (pocketArray != null) {
                    if (broadcast) {
                        DimensionalPockets.CONSOLE.info((Object)"[File System Load] <loadPocketRegistry> Begin loading Pockets from PocketRegistry.");
                    }
                    for (Pocket pocket : pocketArray) {
                        if (pocket.energy_capacity != 500000000) {
                            pocket.energy_capacity = 500000000;
                        }
                        if (pocket.energy_max_receive != 100000) {
                            pocket.energy_max_receive = 100000;
                        }
                        if (pocket.energy_max_extract != 100000) {
                            pocket.energy_max_extract = 100000;
                        }
                        if (pocket.fluid_tank.getFluidTank().getCapacity() != 1000000) {
                            pocket.fluid_tank.getFluidTank().setCapacity(1000000);
                        }
                        if (pocket.getChunkInfo() == null && pocket.chunk_pos != null) {
                            pocket.chunk_info = new PocketChunkInfo(pocket.chunk_pos, true);
                        }
                        newPocketRegistry.put(pocket.getChunkInfo(), pocket);
                        if (!broadcast) continue;
                        if (pocket.getOwner() != null) {
                            DimensionalPockets.CONSOLE.info((Object)("[Pocket Load] <loadPocketRegistry> Pocket loaded into Registry: { ' claimed ' | '" + String.valueOf(pocket.getChunkInfo()) + "' | '" + pocket.getOwnerName() + "' }"));
                            continue;
                        }
                        DimensionalPockets.CONSOLE.info((Object)("[Pocket load] <loadPocketRegistry> Pocket loaded into Registry: { 'unclaimed' | '" + String.valueOf(pocket.getChunkInfo()) + "' }"));
                    }
                    if (broadcast) {
                        DimensionalPockets.CONSOLE.info((Object)"[File System Load] <loadPocketRegistry> Finished loading Pockets from PocketRegistry.");
                    }
                }
            } else {
                try {
                    if (broadcast) {
                        DimensionalPockets.CONSOLE.info((Object)"[File System Load] <loadPocketRegistry> Begin loading Pockets from PocketRegistry.");
                    }
                    try {
                        CompoundTag readTag = CosmosNBTIOHandler.read((File)fileIn);
                        if (readTag.contains("size")) {
                            int size = readTag.getInt("size");
                            for (int i = 0; i < size; ++i) {
                                CompoundTag pocketTag = readTag.getCompound(Integer.toString(i));
                                Pocket pocket = Pocket.readFromNBT(pocketTag, provider);
                                newPocketRegistry.put(pocket.getChunkInfo(), pocket);
                                if (!broadcast) continue;
                                if (pocket.getOwner() != null) {
                                    DimensionalPockets.CONSOLE.info((Object)("[Pocket Load] <loadPocketRegistry> Pocket loaded into Registry: { ' claimed ' | '" + String.valueOf(pocket.getChunkInfo()) + "' | '" + pocket.getOwnerName() + "' }"));
                                    continue;
                                }
                                DimensionalPockets.CONSOLE.info((Object)("[Pocket load] <loadPocketRegistry> Pocket loaded into Registry: { 'unclaimed' | '" + String.valueOf(pocket.getChunkInfo()) + "' }"));
                            }
                        }
                    }
                    catch (Exception readTag) {
                        // empty catch block
                    }
                    if (broadcast) {
                        DimensionalPockets.CONSOLE.info((Object)"[File System Load] <loadPocketRegistry> Finished loading Pockets from PocketRegistry.");
                    }
                }
                catch (Exception e) {
                    DimensionalPockets.CONSOLE.fatal((Object)"[File System Error] <loadPocketRegistry> Could not load PocketRegistry. See stacktrace for more info:", (Throwable)e);
                }
            }
            return newPocketRegistry;
        }
    }

    private static class GSON {
        private static Gson LOADER = new GsonBuilder().registerTypeAdapter(ItemStack.class, (Object)new GsonAdapterItemStack()).registerTypeAdapter(ObjectFluidTankCustom.class, (Object)new GsonAdapterFluidTankCustom()).registerTypeAdapter(ObjectConnectionType.class, (Object)new GsonAdapterConnectionType()).registerTypeAdapter(EnumLockState.class, (Object)new GsonAdapterLockState()).registerTypeAdapter(EnumSideState.class, (Object)new GsonAdapterSideState()).registerTypeAdapter(EnumTrapState.class, (Object)new GsonAdapterTrapState()).registerTypeAdapter(EnumGeneratedState.class, (Object)new GsonAdapterGeneratedState()).registerTypeAdapter(EnumGeneralAllowState.class, (Object)new GsonAdapterGeneralAllowState()).registerTypeAdapter(NonNullList.class, (Object)new GsonAdapterPocketItemsList()).registerTypeAdapter(ObjectBlockPosDimension.class, (Object)new GsonAdapterBlockPosDimension()).registerTypeAdapter(PocketChunkInfo.class, (Object)new GsonAdapterPocketChunkInfo()).enableComplexMapKeySerialization().setPrettyPrinting().create();

        private GSON() {
        }
    }
}

