/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.registry;

import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.lib.CosmosVec2;
import com.tcn.cosmoslibrary.system.primative.ObjectHolder2;
import com.tcn.dimensionalpocketsii.DimensionalPockets;
import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.gson.PocketChunkInfo;
import com.tcn.dimensionalpocketsii.pocket.core.registry.BackupManager;
import com.tcn.dimensionalpocketsii.pocket.core.registry.InterfaceManager;
import java.util.LinkedHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class StorageManager {
    private static LinkedHashMap<PocketChunkInfo, Pocket> registryMap = new LinkedHashMap();
    private static final int pocketChunkSpacing = 4;
    private static final int pocketYOffset = 1;
    private static final int pocketSize = 15;
    private static GenerationParameters generationParams = new GenerationParameters();

    public static int getPocketYOffset() {
        return 1;
    }

    public static int getPocketSize() {
        return 15;
    }

    public static ServerLevel getServerLevel() {
        return ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD);
    }

    public static LinkedHashMap<PocketChunkInfo, Pocket> getRegistry() {
        return registryMap;
    }

    public static void clearRegistry() {
        registryMap.clear();
        DimensionalPockets.CONSOLE.debugWarn((Object)"[Pocket Registry] <clearmap> Pocket Map Cleared");
    }

    public static Pocket getPocketFromChunkPosition(Level levelIn, CosmosChunkPos chunkPos) {
        Pocket[] pocket = new Pocket[]{new Pocket(null)};
        boolean[] found = new boolean[]{false};
        if (chunkPos != null) {
            registryMap.forEach((info, pock) -> {
                if (info.isChunkContained(chunkPos)) {
                    pocket[0] = pock;
                    found[0] = true;
                }
            });
            if (!found[0]) {
                if (levelIn != null) {
                    if (!levelIn.isClientSide()) {
                        DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <getpocket> Unable to retrieve Pocket: { " + String.valueOf(chunkPos) + " }. Chunk Position not present in map. <ChunkPos>"));
                    }
                } else {
                    DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <getpocket> Unable to retrieve Pocket: { " + String.valueOf(chunkPos) + " }. Chunk Position <null>!! <ChunkPos>"));
                }
            }
        } else if (levelIn != null) {
            if (!levelIn.isClientSide()) {
                DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <getpocket> Unable to retrieve Pocket: { " + String.valueOf(chunkPos) + " }. Chunk Position <null>!! <ChunkPos>"));
            }
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <getpocket> Unable to retrieve Pocket: { " + String.valueOf(chunkPos) + " }. Chunk Position <null>!! <ChunkPos>"));
        }
        return pocket[0];
    }

    public static Pocket getPocketFromChunkInfo(Level levelIn, PocketChunkInfo pocketChunkInfoIn) {
        Pocket[] pocket = new Pocket[]{new Pocket(null)};
        if (pocketChunkInfoIn != null) {
            registryMap.forEach((info, pock) -> {
                if (info.getDominantChunk().equals((Object)pocketChunkInfoIn.getDominantChunk()) && info.isSingleChunk() == pocketChunkInfoIn.isSingleChunk()) {
                    pocket[0] = pock;
                }
            });
            if (pocket[0].getChunkInfo() == null) {
                if (levelIn != null) {
                    if (!levelIn.isClientSide()) {
                        DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <getpocket> Unable to retrieve Pocket: { " + String.valueOf(pocketChunkInfoIn) + " }. Chunk Position not present in map. <ChunkInfo>"));
                    }
                } else {
                    DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <getpocket> Unable to retrieve Pocket: { " + String.valueOf(pocketChunkInfoIn) + " }. Chunk Position not present in map. <ChunkInfo>"));
                }
            }
        } else if (levelIn != null) {
            if (!levelIn.isClientSide()) {
                DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <getpocket> Unable to retrieve Pocket: { " + String.valueOf(pocketChunkInfoIn) + " }. Chunk Position <null>!! <ChunkInfo>"));
            }
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <getpocket> Unable to retrieve Pocket: { " + String.valueOf(pocketChunkInfoIn) + " }. Chunk Position <null>!! <ChunkInfo>"));
        }
        return pocket[0];
    }

    public static CosmosChunkPos getNextPocketChunkPosition(CosmosChunkPos currentCoords) {
        CosmosChunkPos[] result = new CosmosChunkPos[]{currentCoords};
        registryMap.keySet().stream().forEach(test -> {
            if (test.getDominantChunk().equals((Object)result[0])) {
                CosmosChunkPos offset = new CosmosChunkPos(0, 0).offset(StorageManager.generationParams.nextPocketCoordsDirection);
                result[0] = new CosmosChunkPos(result[0].getX(), result[0].getZ()).add((double)(offset.getX() * 4), (double)(offset.getZ() * 4));
            }
        });
        Direction clockwise = StorageManager.generationParams.nextPocketCoordsDirection.getClockWise();
        CosmosChunkPos probe = new CosmosChunkPos(0, 0).offset(clockwise);
        CosmosChunkPos probe2 = new CosmosChunkPos(probe.getX() * 4, probe.getZ() * 4);
        CosmosChunkPos probed = new CosmosChunkPos((CosmosVec2)result[0]).add((CosmosVec2)probe2);
        registryMap.keySet().stream().forEach(test -> {
            if (test.getDominantChunk() == probed) {
                StorageManager.generationParams.nextPocketCoordsDirection = clockwise;
            }
        });
        return result[0];
    }

    public static ObjectHolder2<PocketChunkInfo, Pocket> getChunkInfoForPocket(ResourceKey<Level> dimension, BlockPos pos) {
        for (Pocket pocket : registryMap.values()) {
            if (!pocket.getSourceBlockDimension().equals(dimension) || !pocket.doesBlockArrayContain(pos, dimension.location())) continue;
            return new ObjectHolder2((Object)pocket.getChunkInfo(), (Object)pocket);
        }
        return null;
    }

    public static Pocket getOrCreatePocket(Level levelIn, BlockPos coordSetSource, boolean isSingleChunk) {
        ResourceKey dimIDSource = levelIn.dimension();
        ObjectHolder2<PocketChunkInfo, Pocket> chunk = StorageManager.getChunkInfoForPocket((ResourceKey<Level>)dimIDSource, coordSetSource);
        if (chunk != null && StorageManager.getPocketFromChunkInfo(levelIn, (PocketChunkInfo)chunk.getFirst()) != null) {
            return StorageManager.getPocketFromChunkInfo(levelIn, (PocketChunkInfo)chunk.getFirst());
        }
        if (!registryMap.isEmpty()) {
            StorageManager.generationParams.currentChunk = StorageManager.getNextPocketChunkPosition(StorageManager.generationParams.currentChunk);
            Pocket pocket = new Pocket(StorageManager.generationParams.currentChunk, isSingleChunk, (ResourceKey<Level>)dimIDSource, coordSetSource);
            registryMap.put(new PocketChunkInfo(pocket.getDominantChunkPos(), isSingleChunk), pocket);
            StorageManager.saveRegistry((HolderLookup.Provider)levelIn.registryAccess());
            return pocket;
        }
        Pocket pocket = new Pocket(StorageManager.generationParams.currentChunk, isSingleChunk, (ResourceKey<Level>)dimIDSource, coordSetSource);
        registryMap.put(new PocketChunkInfo(pocket.getDominantChunkPos(), isSingleChunk), pocket);
        StorageManager.saveRegistry((HolderLookup.Provider)levelIn.registryAccess());
        return pocket;
    }

    public static void updatePocket(PocketChunkInfo chunkPos, ResourceKey<Level> dimension, BlockPos pos, HolderLookup.Provider provider) {
        Pocket link = registryMap.get(chunkPos);
        if (link == null) {
            DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <updatepocket> Unable to update Pocket: { " + String.valueOf(chunkPos) + " }. No Pocket exists with this Chunk Posision."));
            return;
        }
        link.setSourceBlockDimension(dimension);
        link.addPosToBlockArray(pos, dimension.location());
        StorageManager.saveRegistry(provider);
    }

    public static void updatePocket(CosmosChunkPos chunkPos, Level levelIn, BlockPos pos) {
        Pocket[] link = new Pocket[]{new Pocket(null)};
        registryMap.forEach((info, pock) -> {
            if (info.isChunkContained(chunkPos)) {
                link[0] = pock;
            }
        });
        if (link[0] == null) {
            DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket Registry Error] <updatepocket> Unable to update Pocket: { " + String.valueOf(chunkPos) + " }. No Pocket exists with this Chunk Posision."));
            return;
        }
        link[0].setSourceBlockDimension((ResourceKey<Level>)levelIn.dimension());
        link[0].addPosToBlockArray(pos, levelIn.dimension().location());
        StorageManager.saveRegistry((HolderLookup.Provider)levelIn.registryAccess());
    }

    public static void createBackup(BackupManager.BackupType backupTypeIn, HolderLookup.Provider provider) {
        if (PocketsConfigManager.getInstance().getCreateBackups()) {
            BackupManager.createFullBackup(registryMap, backupTypeIn, provider);
        }
    }

    public static void saveRegistry(HolderLookup.Provider provider) {
        InterfaceManager.Registry.saveToFile(registryMap, InterfaceManager.RegistryFileType.DAT, provider);
        InterfaceManager.GenerationParams.saveToFile(generationParams);
        DimensionalPockets.CONSOLE.debug((Object)"[Pocket Registry] {server} <saveData> Pocket data saved to File System.");
    }

    public static void loadRegistry(HolderLookup.Provider provider) {
        StorageManager.clearRegistry();
        registryMap = InterfaceManager.Registry.loadFromFile(InterfaceManager.RegistryFileType.DAT, provider);
        generationParams = InterfaceManager.GenerationParams.loadFromFile();
        if (!registryMap.isEmpty()) {
            DimensionalPockets.CONSOLE.debug((Object)"[Pocket Registry] {server} <loadData> Pocket data loaded from File System.");
            DimensionalPockets.CONSOLE.debug((Object)"[Pocket Registry] {server} <loadData> Backup of Pocket data created.");
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Pocket Registry] {server} <loadData> Pocket File System returned an empty Map. This must be a new world. Creating a fresh Map...");
        }
    }

    public static class GenerationParameters {
        private CosmosChunkPos currentChunk = new CosmosChunkPos(0, 0);
        private Direction nextPocketCoordsDirection = Direction.NORTH;
    }
}

