/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.shift;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.MathHelper;
import com.tcn.cosmoslibrary.core.teleport.EnumSafeTeleport;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.shift.Shifter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ShifterCore {
    public static final int ticksProtection = 200;
    public static final int strengthProtection = 10;

    public static void sendPlayerToBed(Player playerIn, @Nullable EnumShiftDirection directionIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer server_player = (ServerPlayer)playerIn;
            ShifterCore.shiftPlayerToDimension((Player)server_player, Shifter.createTeleporter((ResourceKey<Level>)server_player.getRespawnDimension(), directionIn, server_player.getRespawnPosition(), playerIn.getRotationVector().y, playerIn.getRotationVector().x, false, false, true), true);
        }
    }

    public static void sendPlayerToBedWithMessage(Player playerIn, @Nullable EnumShiftDirection directionIn, String messageIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            CosmosChatUtil.sendServerPlayerMessage((Player)serverPlayer, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.shifter_core.target_unknown_custom").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.ORANGE, (String)"bold", (String)messageIn)));
            BlockPos pos = new BlockPos(0, 0, 0);
            pos = serverPlayer.getRespawnPosition() != null ? serverPlayer.getRespawnPosition() : ServerLifecycleHooks.getCurrentServer().getLevel(((ServerPlayer)playerIn).getRespawnDimension()).getLevel().getSharedSpawnPos();
            ShifterCore.shiftPlayerToDimension((Player)serverPlayer, Shifter.createTeleporter((ResourceKey<Level>)serverPlayer.getRespawnDimension(), directionIn, pos, playerIn.getRotationVector().y, playerIn.getRotationVector().x, false, false, true), true);
        }
    }

    public static void sendPlayerToDimensionSpawn(Player playerIn, ResourceKey<Level> dimensionIn, @Nullable MutableComponent componentIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (dimensionIn != null) {
                BlockPos spawnPos;
                ServerLevel targetWorld;
                EnumSafeTeleport location;
                if (componentIn != null) {
                    CosmosChatUtil.sendServerPlayerMessage((Player)serverPlayer, (Component)componentIn);
                }
                if ((location = EnumSafeTeleport.getValidTeleportLocation((Level)(targetWorld = ServerLifecycleHooks.getCurrentServer().getLevel(dimensionIn)), (BlockPos)(spawnPos = targetWorld.getSharedSpawnPos()))) != EnumSafeTeleport.UNKNOWN) {
                    BlockPos locationPos = location.toBlockPos();
                    BlockPos targetPos = MathHelper.addBlockPos((BlockPos)spawnPos, (BlockPos)locationPos);
                    ShifterCore.shiftPlayerToDimension((Player)serverPlayer, Shifter.createTeleporter(dimensionIn, EnumShiftDirection.GENERIC, targetPos, 0.0f, 0.0f, false, false, false), true);
                } else {
                    CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)serverPlayer, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.shifter_core.direction_unknown"));
                }
            } else {
                CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)serverPlayer, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.shifter_core.dimension_null"));
            }
        }
    }

    public static void shiftPlayerToDimension(Player playerIn, Shifter shifterIn, boolean protect) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            Level player_world = playerIn.level();
            ResourceKey<Level> dimension_key = shifterIn.getDimensionKey();
            EnumShiftDirection direction = shifterIn.getDirection();
            if (dimension_key != null) {
                if (direction != EnumShiftDirection.UNKNOWN) {
                    MinecraftServer Mserver = ServerLifecycleHooks.getCurrentServer();
                    ServerLevel server_world = Mserver.getLevel(dimension_key);
                    BlockPos target_pos = shifterIn.getTargetPos();
                    if (server_world != null) {
                        if (target_pos != null) {
                            double[] position = shifterIn.getTargetPosA();
                            if (shifterIn.getSendMessage()) {
                                CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)serverPlayer, (Component)direction.getChatComponentForDirection());
                            }
                            DimensionTransition trans = new DimensionTransition(server_world, target_pos.getCenter(), playerIn.getDeltaMovement(), shifterIn.getTargetRotation()[0], shifterIn.getTargetRotation()[1], DimensionTransition.DO_NOTHING);
                            serverPlayer.changeDimension(trans);
                            if (protect) {
                                serverPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 10));
                            }
                            if (!shifterIn.playVanillaSound()) {
                                serverPlayer.connection.send((Packet)new ClientboundSoundPacket(direction.getSound(), SoundSource.AMBIENT, position[0], position[1], position[2], 0.4f, 1.0f, 0L));
                            }
                        } else {
                            DimensionTransition trans = new DimensionTransition(server_world, BlockPos.ZERO.getCenter(), playerIn.getDeltaMovement(), shifterIn.getTargetRotation()[0], shifterIn.getTargetRotation()[1], DimensionTransition.DO_NOTHING);
                            serverPlayer.changeDimension(trans);
                            if (protect) {
                                serverPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 10));
                            }
                            CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)serverPlayer, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.shifter_core.target_unknown"));
                        }
                    } else {
                        CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)serverPlayer, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.shifter_core.server_world_null"));
                    }
                } else {
                    CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)serverPlayer, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.shifter_core.direction_unknown"));
                }
            } else {
                CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)serverPlayer, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.shifter_core.dimension_null"));
            }
        }
    }
}

