/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.network;

import com.tcn.dimensionalpocketsii.DimensionalPockets;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsSoundManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.AbstractBlockEntityPocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityFocus;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleArmourWorkbench;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleCharger;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleConnector;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleGenerator;
import com.tcn.dimensionalpocketsii.pocket.core.management.PocketFocusManager;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.network.PacketPocketNet;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketAllowedPlayer;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketBlockSideState;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketEmptyTank;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketHostileSpawnState;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketLock;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketLockToAllowedPlayers;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketTrapPlayers;
import com.tcn.dimensionalpocketsii.pocket.network.packet.block.PacketSideGuide;
import com.tcn.dimensionalpocketsii.pocket.network.packet.connector.PacketConnectionType;
import com.tcn.dimensionalpocketsii.pocket.network.packet.connector.PacketSideState;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketArmourItem;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketChargerEnergyState;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketFocus;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketFocusTeleport;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketGeneratorEmptyTank;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketGeneratorMode;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketWorkbench;
import com.tcn.dimensionalpocketsii.pocket.network.packet.system.PacketSystem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PocketServerPacketHandler {
    public static void handleDataOnNetwork(PacketPocketNet data, IPayloadContext context) {
        Record packet;
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        if (data instanceof PacketSystem) {
            packet = (PacketSystem)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$0((PacketSystem)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketLock) {
            packet = (PacketLock)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$1((PacketLock)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketAllowedPlayer) {
            packet = (PacketAllowedPlayer)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$2((PacketAllowedPlayer)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketBlockSideState) {
            packet = (PacketBlockSideState)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$3((PacketBlockSideState)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketEmptyTank) {
            packet = (PacketEmptyTank)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$4((PacketEmptyTank)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketTrapPlayers) {
            packet = (PacketTrapPlayers)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$5((PacketTrapPlayers)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketHostileSpawnState) {
            packet = (PacketHostileSpawnState)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$6((PacketHostileSpawnState)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketLockToAllowedPlayers) {
            packet = (PacketLockToAllowedPlayers)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$7((PacketLockToAllowedPlayers)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketConnectionType) {
            packet = (PacketConnectionType)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$8((PacketConnectionType)packet));
        }
        if (data instanceof PacketSideState) {
            packet = (PacketSideState)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$9((PacketSideState)packet));
        }
        if (data instanceof PacketSideGuide) {
            packet = (PacketSideGuide)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$10((PacketSideGuide)packet));
        }
        if (data instanceof PacketArmourItem) {
            packet = (PacketArmourItem)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$11((PacketArmourItem)packet));
        }
        if (data instanceof PacketChargerEnergyState) {
            packet = (PacketChargerEnergyState)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$12((PacketChargerEnergyState)packet));
        }
        if (data instanceof PacketGeneratorMode) {
            packet = (PacketGeneratorMode)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$13((PacketGeneratorMode)packet));
        }
        if (data instanceof PacketGeneratorEmptyTank) {
            packet = (PacketGeneratorEmptyTank)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$14((PacketGeneratorEmptyTank)packet));
        }
        if (data instanceof PacketFocus) {
            packet = (PacketFocus)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$15((PacketFocus)packet));
        }
        if (data instanceof PacketFocusTeleport) {
            packet = (PacketFocusTeleport)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$16(context, (PacketFocusTeleport)packet));
        }
        if (data instanceof PacketWorkbench) {
            packet = (PacketWorkbench)data;
            context.enqueueWork(() -> PocketServerPacketHandler.lambda$handleDataOnNetwork$17((PacketWorkbench)packet));
        }
    }

    public static void sendConsoleMessage(boolean removed, boolean connector, Pocket pocket, String added) {
        String noun = removed ? "removed" : "added";
        DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] <allowedplayer:" + noun + "> Allowed Player " + noun + " for Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " } [ Owner: { " + pocket.getOwnerName() + " } Player: { " + added + " } ]"));
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$17(PacketWorkbench packet) {
        BlockEntity entity = ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD).getBlockEntity(packet.pos());
        if (entity instanceof BlockEntityModuleArmourWorkbench) {
            BlockEntityModuleArmourWorkbench blockEntity = (BlockEntityModuleArmourWorkbench)entity;
            blockEntity.updateColour(packet.colour(), packet.wingColour());
            DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] {workbench} <updateColour> Colour updated to: { " + packet.colour().getName() + ", " + (packet.wingColour() ? " wing" : " armour") + " }"));
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] {workbench} <updateColour> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$16(IPayloadContext context, PacketFocusTeleport packet) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (PocketFocusManager.isBadTeleportPacket(packet, serverPlayer)) {
                return;
            }
            ServerLevel world = serverPlayer.serverLevel();
            BlockPos toPos = packet.toPos();
            BlockState toState = world.getBlockState(packet.toPos());
            float yaw = player.getYRot();
            float pitch = player.getXRot();
            double toX = (double)toPos.getX() + 0.5;
            double toZ = (double)toPos.getZ() + 0.5;
            double blockYOffset = toState.getBlockSupportShape((BlockGetter)world, toPos).max(Direction.Axis.Y);
            serverPlayer.teleportTo(world, toX, (double)toPos.getY() + blockYOffset, toZ, yaw, pitch);
            serverPlayer.setDeltaMovement(serverPlayer.getDeltaMovement().multiply(new Vec3(1.0, 0.0, 1.0)));
            world.playSound(null, toPos, (SoundEvent)PocketsSoundManager.WOOSH.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$15(PacketFocus packet) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD);
        BlockEntity entity = world.getBlockEntity(packet.pos());
        if (entity instanceof BlockEntityFocus) {
            BlockEntityFocus blockEntity = (BlockEntityFocus)entity;
            boolean value = packet.boolValue();
            if (packet.doJump()) {
                blockEntity.setJumpEnabled(value);
                DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] {focus} <jumpenabled> Jump Mode set to: { " + value + " }"));
            } else {
                blockEntity.setShiftEnabled(value);
                DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] {focus} <shiftenabled> Shift Mode set to: { " + value + " }"));
            }
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] {generator} <generationmode> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$14(PacketGeneratorEmptyTank packet) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD);
        BlockEntity entity = world.getBlockEntity(packet.pos());
        if (entity instanceof BlockEntityModuleGenerator) {
            BlockEntityModuleGenerator blockEntity = (BlockEntityModuleGenerator)entity;
            blockEntity.getFluidTank().setFluid(FluidStack.EMPTY);
            DimensionalPockets.CONSOLE.debug((Object)"[Packet Delivery Success] {generator} <emptytank> Fluid Tank Emptied.");
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] {generator} <emptytank> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$13(PacketGeneratorMode packet) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD);
        BlockEntity entity = world.getBlockEntity(packet.pos());
        if (entity instanceof BlockEntityModuleGenerator) {
            BlockEntityModuleGenerator blockEntity = (BlockEntityModuleGenerator)entity;
            blockEntity.cycleGenerationMode();
            DimensionalPockets.CONSOLE.debug((Object)"[Packet Delivery Success] {generator} <generationmode> Generation Mode cycled.");
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] {generator} <generationmode> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$12(PacketChargerEnergyState packet) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD);
        BlockEntity entity = world.getBlockEntity(packet.pos());
        if (entity instanceof BlockEntityModuleCharger) {
            BlockEntityModuleCharger blockEntity = (BlockEntityModuleCharger)entity;
            blockEntity.cycleEnergyState();
            DimensionalPockets.CONSOLE.debug((Object)"[Packet Delivery Success] {charger} <chargemode> Charge Mode cycled.");
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] {charger} <chargemode> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$11(PacketArmourItem packet) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD);
        BlockEntity entity = world.getBlockEntity(packet.pos());
        if (entity instanceof BlockEntityModuleArmourWorkbench) {
            BlockEntityModuleArmourWorkbench blockEntity = (BlockEntityModuleArmourWorkbench)entity;
            if (packet.doApply()) {
                blockEntity.applyToArmourItem(packet.doColour(), packet.doModule());
                DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] {armourworkbench} <itemfunction> Values: { 'colour': " + packet.doColour() + ", 'module': " + packet.doModule() + " } applied to Item."));
            } else {
                blockEntity.removeFromArmourItem();
                DimensionalPockets.CONSOLE.debug((Object)"[Packet Delivery Success] {armourworkbench} <itemfunction> All module values removed from Item.");
            }
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] {armourworkbench} <itemfunction> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$10(PacketSideGuide packet) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerLevel world = server.getLevel(packet.dimension());
        BlockEntity entity = world.getBlockEntity(packet.pos());
        if (entity instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)entity;
            blockEntity.toggleSideGuide();
            blockEntity.sendUpdates(true);
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] <sideguide> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$9(PacketSideState packet) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD);
        BlockEntity entity = world.getBlockEntity(packet.pos());
        if (entity instanceof BlockEntityModuleConnector) {
            BlockEntityModuleConnector blockEntity = (BlockEntityModuleConnector)entity;
            if (blockEntity.getPocket().exists()) {
                blockEntity.cycleSide(Direction.UP, true);
                DimensionalPockets.CONSOLE.debug((Object)"[Packet Delivery Success] {connector} <sidestate> Side State cycled.");
            }
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] {connector} <sidestate> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$8(PacketConnectionType packet) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(PocketsDimensionManager.POCKET_WORLD);
        BlockEntity entity = world.getBlockEntity(packet.pos());
        if (entity instanceof BlockEntityModuleConnector) {
            BlockEntityModuleConnector blockEntity = (BlockEntityModuleConnector)entity;
            if (blockEntity.getPocket().exists()) {
                blockEntity.cycleConnectionType(true);
                DimensionalPockets.CONSOLE.debug((Object)"[Packet Delivery Success] {connector} <connectiontype> Connection Type cycled.");
            }
        } else {
            DimensionalPockets.CONSOLE.debugWarn((Object)"[Packet Delivery Failure] {connector} <connectiontype> Block Entity not equal to expected.");
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$7(PacketLockToAllowedPlayers packet, HolderLookup.Provider provider) {
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, packet.pos());
        if (pocket.exists()) {
            pocket.setAllowedPlayerState(packet.doLock());
            pocket.forceUpdateInsidePocket();
            DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] <locktoallowedplayers> Lock to Allowed Players setting set to: { " + packet.doLock() + " } for Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " }"));
        }
        StorageManager.saveRegistry(provider);
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$6(PacketHostileSpawnState packet, HolderLookup.Provider provider) {
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, packet.pos());
        if (pocket.exists()) {
            pocket.setHostileSpawnState(packet.state());
            pocket.forceUpdateInsidePocket();
            DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] <hosentityspawnstate> Hosentity Spawn setting set to: { " + packet.state() + " } for Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " }"));
        }
        StorageManager.saveRegistry(provider);
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$5(PacketTrapPlayers packet, HolderLookup.Provider provider) {
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, packet.pos());
        if (pocket.exists()) {
            pocket.setTrapState(packet.doLock());
            pocket.forceUpdateInsidePocket();
            DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] <trapplayers> Trap Players setting set to: { " + packet.doLock() + " } for Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " }"));
        }
        StorageManager.saveRegistry(provider);
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$4(PacketEmptyTank packet, HolderLookup.Provider provider) {
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, packet.pos());
        if (pocket.exists()) {
            pocket.emptyFluidTank();
            pocket.forceUpdateInsidePocket();
            pocket.forceUpdateOutsidePocket();
            DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] <emptytank> Fluid Tank Emptied for Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " }"));
        }
        StorageManager.saveRegistry(provider);
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$3(PacketBlockSideState packet, HolderLookup.Provider provider) {
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, packet.pos());
        if (pocket.exists()) {
            pocket.cycleSide(Direction.from3DDataValue((int)packet.index()), true);
            pocket.forceUpdateInsidePocket();
            pocket.forceUpdateOutsidePocket();
            DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] <pocketsidestate> Pocket Side State cycled for Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " }"));
        }
        StorageManager.saveRegistry(provider);
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$2(PacketAllowedPlayer packet, HolderLookup.Provider provider) {
        String player_name = packet.playerName();
        boolean add = packet.doAdd();
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, packet.pos());
        if (!player_name.isEmpty() && pocket.exists()) {
            if (add) {
                pocket.addAllowedPlayerNBT(player_name);
                PocketServerPacketHandler.sendConsoleMessage(false, true, pocket, player_name);
            } else {
                pocket.removeAllowedPlayerNBT(player_name);
                PocketServerPacketHandler.sendConsoleMessage(true, true, pocket, player_name);
            }
            pocket.forceUpdateInsidePocket();
            pocket.forceUpdateOutsidePocket();
        }
        StorageManager.saveRegistry(provider);
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$1(PacketLock packet, HolderLookup.Provider provider) {
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, packet.pos());
        if (pocket.exists()) {
            pocket.setLockState(packet.doLock());
            pocket.forceUpdateInsidePocket();
            pocket.forceUpdateOutsidePocket();
            DimensionalPockets.CONSOLE.debug((Object)("[Packet Delivery Success] <lock> Lock setting set to: { " + packet.doLock() + " } for Pocket: { " + String.valueOf(pocket.getDominantChunkPos()) + " }"));
        }
        StorageManager.saveRegistry(provider);
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$0(PacketSystem packet, HolderLookup.Provider provider) {
        if (packet.doSave()) {
            StorageManager.saveRegistry(provider);
        } else {
            StorageManager.loadRegistry(provider);
        }
    }
}

